/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.Serializable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogSource;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.regexp.RESyntaxException;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.util.StrutsValidatorUtil;

public class StrutsValidator
implements Serializable {
    private static Log LOG = LogSource.getInstance((String)(class$org$apache$struts$util$StrutsValidator == null ? (class$org$apache$struts$util$StrutsValidator = StrutsValidator.class$("org.apache.struts.util.StrutsValidator")) : class$org$apache$struts$util$StrutsValidator).getName());
    static /* synthetic */ Class class$org$apache$struts$util$StrutsValidator;

    public static boolean validateRequired(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = null;
        if (field.getProperty() != null && field.getProperty().length() > 0) {
            value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        }
        if (GenericValidator.isBlankOrNull(value)) {
            errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateMask(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String mask = field.getVarValue("mask");
        if (field.getProperty() != null && field.getProperty().length() > 0) {
            String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
            try {
                if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.matchRegexp((String)value, (String)mask)) {
                    errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
                    return false;
                }
                return true;
            }
            catch (RESyntaxException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public static boolean validateByte(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isByte((String)value)) {
            errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateShort(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isShort((String)value)) {
            errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateInteger(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isInt((String)value)) {
            errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateLong(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isLong((String)value)) {
            errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateFloat(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isFloat((String)value)) {
            errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateDouble(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isDouble((String)value)) {
            errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateDate(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        boolean bValid = true;
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");
        Locale locale = StrutsValidatorUtil.getLocale(request);
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                bValid = datePattern != null && datePattern.length() > 0 ? GenericValidator.isDate((String)value, (String)datePattern, (boolean)false) : (datePatternStrict != null && datePatternStrict.length() > 0 ? GenericValidator.isDate((String)value, (String)datePatternStrict, (boolean)true) : GenericValidator.isDate((String)value, (Locale)locale));
            }
            catch (Exception e) {
                bValid = false;
            }
        }
        if (!bValid) {
            errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
        }
        return bValid;
    }

    public static boolean validateRange(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        String sMin = field.getVarValue("min");
        String sMax = field.getVarValue("max");
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int iValue = Integer.parseInt(value);
                int min = Integer.parseInt(sMin);
                int max = Integer.parseInt(sMax);
                if (!GenericValidator.isInRange((int)iValue, (int)min, (int)max)) {
                    errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateCreditCard(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        if (field.getProperty() != null && field.getProperty().length() > 0) {
            String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
            if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isCreditCard((String)value)) {
                errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateEmail(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isEmail((String)value)) {
            errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateMaxLength(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        String sMaxLength = field.getVarValue("maxlength");
        if (value != null) {
            try {
                int max = Integer.parseInt(sMaxLength);
                if (!GenericValidator.maxLength((String)value, (int)max)) {
                    errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateMinLength(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        String sMinLength = field.getVarValue("minlength");
        if (value != null) {
            try {
                int min = Integer.parseInt(sMinLength);
                if (!GenericValidator.minLength((String)value, (int)min)) {
                    errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), StrutsValidatorUtil.getActionError(request, va, field));
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

