/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericDataSource
implements DataSource {
    protected BasicDataSource dataSource = null;
    protected Log log = LogFactory.getLog(this.getClass());
    protected boolean autoCommit = true;
    protected String driverClass = null;
    protected int maxCount = 2;
    protected int maxIdle = 0;
    protected long maxWait = -1L;
    protected int minCount = 1;
    protected String password = null;
    protected String pingQuery = null;
    protected boolean readOnly = false;
    protected String url = null;
    protected String user = null;

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPingQuery() {
        return this.pingQuery;
    }

    public void setPingQuery(String pingQuery) {
        this.pingQuery = pingQuery;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Connection getConnection() throws SQLException {
        return this.createDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.createDataSource().getConnection(username, password);
    }

    public int getLoginTimeout() throws SQLException {
        return this.createDataSource().getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.createDataSource().setLoginTimeout(loginTimeout);
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.createDataSource().setLogWriter(logWriter);
    }

    public void close() throws SQLException {
        this.createDataSource().close();
    }

    public void open() throws SQLException {
        this.createDataSource();
    }

    protected synchronized BasicDataSource createDataSource() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating new BasicDataSource");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("   autoCommit=" + this.getAutoCommit()));
            this.log.trace((Object)("  driverClass=" + this.getDriverClass()));
            this.log.trace((Object)("     maxCount=" + this.getMaxCount()));
            this.log.trace((Object)("      maxIdle=" + this.getMaxIdle()));
            this.log.trace((Object)("      maxWait=" + this.getMaxWait()));
            this.log.trace((Object)("     password=" + this.getPassword()));
            this.log.trace((Object)("    pingQuery=" + this.getPingQuery()));
            this.log.trace((Object)("     readOnly=" + this.getReadOnly()));
            this.log.trace((Object)("          url=" + this.getUrl()));
            this.log.trace((Object)("         user=" + this.getUser()));
        }
        BasicDataSource bds = new BasicDataSource();
        bds.setDefaultAutoCommit(this.getAutoCommit());
        bds.setDefaultReadOnly(this.getReadOnly());
        bds.setDriverClassName(this.getDriverClass());
        bds.setMaxActive(this.getMaxCount());
        bds.setMaxIdle(this.getMaxIdle());
        bds.setMaxWait(this.getMaxWait());
        bds.setPassword(this.getPassword());
        bds.setUrl(this.getUrl());
        bds.setUsername(this.getUser());
        bds.setValidationQuery(this.getPingQuery());
        this.dataSource = bds;
        return this.dataSource;
    }
}

