/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.struts.config.FormPropertyConfig;

public class FormBeanConfig
implements Serializable {
    protected boolean configured = false;
    protected HashMap formProperties = new HashMap();
    protected boolean dynamic = false;
    protected String name = null;
    protected String type = null;

    public boolean getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.dynamic = dynamic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.type = type;
        if ("org.apache.struts.action.DynaActionForm".equals(type)) {
            this.dynamic = true;
        }
    }

    public void addFormPropertyConfig(FormPropertyConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formProperties.put(config.getName(), config);
    }

    public FormPropertyConfig findFormPropertyConfig(String name) {
        return (FormPropertyConfig)this.formProperties.get(name);
    }

    public FormPropertyConfig[] findFormPropertyConfigs() {
        FormPropertyConfig[] results = new FormPropertyConfig[this.formProperties.size()];
        return this.formProperties.values().toArray(results);
    }

    public void freeze() {
        this.configured = true;
        FormPropertyConfig[] fpconfigs = this.findFormPropertyConfigs();
        int i = 0;
        while (i < fpconfigs.length) {
            fpconfigs[i].freeze();
            ++i;
        }
    }

    public void removeFormPropertyConfig(FormPropertyConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formProperties.remove(config.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FormBeanConfig[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(",type=");
        sb.append(this.type);
        sb.append("]");
        return sb.toString();
    }
}

