/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.AttributeNode;
import com.sun.xml.tree.CDataNode;
import com.sun.xml.tree.CommentNode;
import com.sun.xml.tree.Doctype;
import com.sun.xml.tree.DocumentEx;
import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementEx;
import com.sun.xml.tree.ElementFactory;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.PINode;
import com.sun.xml.tree.ParentNode;
import com.sun.xml.tree.TextNode;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocumentBuilder;
import com.sun.xml.tree.XmlWriteContext;
import com.sun.xml.util.MessageCatalog;
import com.sun.xml.util.XmlNames;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlDocument
extends ParentNode
implements DocumentEx,
DOMImplementation {
    static String eol;
    static final MessageCatalog catalog;
    private Locale locale = Locale.getDefault();
    private String systemId;
    private ElementFactory factory;
    int mutationCount;
    boolean replaceRootElement;
    static /* synthetic */ Class class$com$sun$xml$tree$XmlDocument$Catalog;

    static {
        String string;
        try {
            string = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException securityException) {
            string = "\n";
        }
        eol = string;
        catalog = new Catalog();
    }

    public Node appendChild(Node node) throws DOMException {
        if (node instanceof Element && this.getDocument() != null) {
            throw new DomEx(3);
        }
        if (node instanceof DocumentType && this.getDoctype() != null) {
            throw new DomEx(3);
        }
        return super.appendChild(node);
    }

    public final void changeNodeOwner(Node node) throws DOMException {
        Object object;
        ElementNode elementNode;
        if (node.getOwnerDocument() == this) {
            return;
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(4);
        }
        switch (node.getNodeType()) {
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                throw new DomEx(3);
            }
        }
        if (node instanceof AttributeNode && (elementNode = ((AttributeNode)(object = (AttributeNode)node)).getNameScope()) != null && elementNode.getOwnerDocument() != this) {
            throw new DomEx(3);
        }
        NodeBase nodeBase = (NodeBase)node.getParentNode();
        if (nodeBase != null) {
            nodeBase.removeChild(node);
        }
        TreeWalker treeWalker = new TreeWalker(node);
        nodeBase = (NodeBase)treeWalker.getCurrent();
        while (nodeBase != null) {
            nodeBase.setOwnerDocument(this);
            if (nodeBase instanceof ElementNode) {
                object = nodeBase.getAttributes();
                int n = object.getLength();
                int n2 = 0;
                while (n2 < n) {
                    this.changeNodeOwner(object.item(n2));
                    ++n2;
                }
            }
            nodeBase = (NodeBase)treeWalker.getNext();
        }
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 7: 
            case 8: 
            case 10: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public Locale chooseLocale(String[] stringArray) {
        Locale locale = catalog.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Node cloneNode(boolean bl) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.systemId = this.systemId;
        if (bl) {
            Node node;
            int n = 0;
            while ((node = this.item(n)) != null) {
                if (!(node instanceof DocumentType)) {
                    node = node.cloneNode(true);
                    xmlDocument.changeNodeOwner(node);
                    xmlDocument.appendChild(node);
                }
                ++n;
            }
        }
        return xmlDocument;
    }

    public Attr createAttribute(String string) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        AttributeNode attributeNode = new AttributeNode(string, null, true, null);
        attributeNode.setOwnerDocument(this);
        return attributeNode;
    }

    public CDATASection createCDATASection(String string) {
        CDataNode cDataNode = new CDataNode();
        if (string != null) {
            cDataNode.setText(string.toCharArray());
        }
        cDataNode.setOwnerDocument(this);
        return cDataNode;
    }

    public Comment createComment(String string) {
        CommentNode commentNode = new CommentNode(string);
        commentNode.setOwnerDocument(this);
        return commentNode;
    }

    Doctype createDoctype(String string) {
        Doctype doctype = new Doctype(string);
        doctype.setOwnerDocument(this);
        return doctype;
    }

    public DocumentFragment createDocumentFragment() {
        DocFragNode docFragNode = new DocFragNode();
        docFragNode.setOwnerDocument(this);
        return docFragNode;
    }

    public final Element createElement(String string) throws DOMException {
        return this.createElementEx(string);
    }

    public final ElementEx createElementEx(String string) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        ElementNode elementNode = this.factory != null ? (ElementNode)this.factory.createElementEx(string) : new ElementNode();
        elementNode.setTag(string);
        elementNode.setOwnerDocument(this);
        return elementNode;
    }

    public final ElementEx createElementEx(String string, String string2) throws DOMException {
        if (!XmlNames.isName(string2)) {
            throw new DomEx(5);
        }
        ElementNode elementNode = this.factory != null ? (ElementNode)this.factory.createElementEx(string, string2) : new ElementNode();
        elementNode.setTag(string2);
        elementNode.setOwnerDocument(this);
        return elementNode;
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        EntityRefNode entityRefNode = new EntityRefNode(string);
        entityRefNode.setOwnerDocument(this);
        return entityRefNode;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        PINode pINode = new PINode(string, string2);
        pINode.setOwnerDocument(this);
        return pINode;
    }

    public Text createTextNode(String string) {
        TextNode textNode = new TextNode();
        textNode.setOwnerDocument(this);
        if (string != null) {
            textNode.setText(string.toCharArray());
        }
        return textNode;
    }

    public XmlWriteContext createWriteContext(Writer writer) {
        return new ExtWriteContext(writer);
    }

    public XmlWriteContext createWriteContext(Writer writer, int n) {
        return new ExtWriteContext(writer, n);
    }

    public static XmlDocument createXmlDocument(InputStream inputStream, boolean bl) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(inputStream), bl);
    }

    public static XmlDocument createXmlDocument(String string) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(string), false);
    }

    public static XmlDocument createXmlDocument(String string, boolean bl) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(string), bl);
    }

    public static XmlDocument createXmlDocument(InputSource inputSource, boolean bl) throws IOException, SAXException {
        XmlDocumentBuilder xmlDocumentBuilder;
        Parser parser;
        try {
            parser = bl ? new ValidatingParser(true) : new Parser();
            parser.setEntityResolver(new Resolver());
            xmlDocumentBuilder = new XmlDocumentBuilder();
            xmlDocumentBuilder.setDisableNamespaces(true);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        xmlDocumentBuilder.setParser(parser);
        parser.parse(inputSource);
        return xmlDocumentBuilder.getDocument();
    }

    public final DocumentType getDoctype() {
        int n = 0;
        Node node;
        while ((node = this.item(n)) != null) {
            if (node instanceof DocumentType) {
                return (DocumentType)node;
            }
            ++n;
        }
        return null;
    }

    ElementNode getDocument() {
        int n = 0;
        Node node;
        while ((node = this.item(n)) != null) {
            if (node instanceof ElementNode) {
                return (ElementNode)node;
            }
            ++n;
        }
        return null;
    }

    public Element getDocumentElement() {
        return this.getDocument();
    }

    public ElementEx getElementExById(String string) {
        ElementEx elementEx;
        if (string == null) {
            throw new IllegalArgumentException(this.getMessage("XD-000"));
        }
        TreeWalker treeWalker = new TreeWalker(this);
        while ((elementEx = (ElementEx)treeWalker.getNextElement(null)) != null) {
            String string2;
            String string3 = elementEx.getIdAttributeName();
            if (string3 == null || !(string2 = elementEx.getAttribute(string3)).equals(string)) continue;
            return elementEx;
        }
        return null;
    }

    public final ElementFactory getElementFactory() {
        return this.factory;
    }

    public DOMImplementation getImplementation() {
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final String getNodeName() {
        return "#document";
    }

    public final short getNodeType() {
        return 9;
    }

    public Document getOwnerDoc() {
        return null;
    }

    public final String getSystemId() {
        return this.systemId;
    }

    public boolean hasFeature(String string, String string2) {
        if (!"XML".equalsIgnoreCase(string)) {
            return false;
        }
        return string2 != null && "1.0".equals(string2);
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (!this.replaceRootElement && node instanceof Element && this.getDocument() != null) {
            throw new DomEx(3);
        }
        if (!this.replaceRootElement && node instanceof DocumentType && this.getDoctype() != null) {
            throw new DomEx(3);
        }
        return super.insertBefore(node, node2);
    }

    static String java2std(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("ISO8859_")) {
            return "ISO-8859-" + string.substring(8);
        }
        if (string.startsWith("8859_")) {
            return "ISO-8859-" + string.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(string)) {
            return "UTF-8";
        }
        if (string.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(string)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(string)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(string)) {
            return "EUC-JP";
        }
        return string;
    }

    TextNode newText(char[] cArray, int n, int n2) throws SAXException {
        TextNode textNode = (TextNode)this.createTextNode(null);
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        textNode.setText(cArray2);
        return textNode;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node instanceof DocumentFragment) {
            Node node3;
            int n = 0;
            int n2 = 0;
            this.replaceRootElement = false;
            ParentNode parentNode = (ParentNode)node;
            int n3 = 0;
            while ((node3 = parentNode.item(n3)) != null) {
                if (node3 instanceof Element) {
                    ++n;
                } else if (node3 instanceof DocumentType) {
                    ++n2;
                }
                ++n3;
            }
            if (n > 1 || n2 > 1) {
                throw new DomEx(3);
            }
            this.replaceRootElement = true;
        }
        return super.replaceChild(node, node2);
    }

    public DocumentType setDoctype(String string, String string2, String string3) {
        Doctype doctype = (Doctype)this.getDoctype();
        if (doctype != null) {
            doctype.setPrintInfo(string, string2, string3);
        } else {
            doctype = new Doctype(string, string2, string3);
            doctype.setOwnerDocument(this);
            this.insertBefore(doctype, this.getFirstChild());
        }
        return doctype;
    }

    public final void setElementFactory(ElementFactory elementFactory) {
        this.factory = elementFactory;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public final void setSystemId(String string) {
        this.systemId = string;
    }

    public void write(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        this.write(outputStreamWriter, "UTF-8");
    }

    public void write(Writer writer) throws IOException {
        String string = null;
        if (writer instanceof OutputStreamWriter) {
            string = XmlDocument.java2std(((OutputStreamWriter)writer).getEncoding());
        }
        this.write(writer, string);
    }

    public void write(Writer writer, String string) throws IOException {
        writer.write("<?xml version=\"1.0\"");
        if (string != null) {
            writer.write(" encoding=\"");
            writer.write(string);
            writer.write(34);
        }
        writer.write("?>");
        writer.write(eol);
        writer.write(eol);
        this.writeChildrenXml(this.createWriteContext(writer, 0));
        writer.write(eol);
        writer.flush();
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
        int n = this.getLength();
        Writer writer = xmlWriteContext.getWriter();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            ((NodeBase)this.item(n2)).writeXml(xmlWriteContext);
            writer.write(eol);
            ++n2;
        }
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        String string = null;
        if (writer instanceof OutputStreamWriter) {
            string = XmlDocument.java2std(((OutputStreamWriter)writer).getEncoding());
        }
        writer.write("<?xml version=\"1.0\"");
        if (string != null) {
            writer.write(" encoding=\"");
            writer.write(string);
            writer.write(34);
        }
        writer.write("?>");
        writer.write(eol);
        writer.write(eol);
        this.writeChildrenXml(xmlWriteContext);
    }

    static final class DocFragNode
    extends ParentNode
    implements DocumentFragment {
        DocFragNode() {
        }

        void checkChildType(int n) throws DOMException {
            switch (n) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return;
                }
            }
            throw new DomEx(3);
        }

        public Node cloneNode(boolean bl) {
            DocFragNode docFragNode = new DocFragNode();
            docFragNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            if (bl) {
                Node node;
                int n = 0;
                while ((node = this.item(n)) != null) {
                    node = node.cloneNode(true);
                    docFragNode.appendChild(node);
                    ++n;
                }
            }
            return docFragNode;
        }

        public String getNodeName() {
            return "#document-fragment";
        }

        public short getNodeType() {
            return 11;
        }

        public Node getParentNode() {
            return null;
        }

        public void setParentNode(Node node) {
            if (node != null) {
                throw new IllegalArgumentException();
            }
        }

        public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
            this.writeChildrenXml(xmlWriteContext);
        }
    }

    static final class EntityRefNode
    extends ParentNode
    implements EntityReference {
        private String entity;

        EntityRefNode(String string) {
            if (string == null) {
                throw new IllegalArgumentException(this.getMessage("XD-002"));
            }
            this.entity = string;
        }

        void checkChildType(int n) throws DOMException {
            switch (n) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return;
                }
            }
            throw new DomEx(3);
        }

        public Node cloneNode(boolean bl) {
            EntityRefNode entityRefNode = new EntityRefNode(this.entity);
            entityRefNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            if (bl) {
                Node node;
                int n = 0;
                while ((node = this.item(n)) != null) {
                    node = node.cloneNode(true);
                    entityRefNode.appendChild(node);
                    ++n;
                }
            }
            return entityRefNode;
        }

        public String getNodeName() {
            return this.entity;
        }

        public short getNodeType() {
            return 5;
        }

        public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
            if (!xmlWriteContext.isEntityDeclared(this.entity)) {
                throw new IOException(this.getMessage("XD-003", new Object[]{this.entity}));
            }
            Writer writer = xmlWriteContext.getWriter();
            writer.write(38);
            writer.write(this.entity);
            writer.write(59);
        }
    }

    class ExtWriteContext
    extends XmlWriteContext {
        ExtWriteContext(Writer writer) {
            super(writer);
        }

        ExtWriteContext(Writer writer, int n) {
            super(writer, n);
        }

        public boolean isEntityDeclared(String string) {
            if (super.isEntityDeclared(string)) {
                return true;
            }
            DocumentType documentType = XmlDocument.this.getDoctype();
            if (documentType == null) {
                return false;
            }
            return documentType.getEntities().getNamedItem(string) != null;
        }
    }

    static class Catalog
    extends MessageCatalog {
        Catalog() {
            super(class$com$sun$xml$tree$XmlDocument$Catalog != null ? class$com$sun$xml$tree$XmlDocument$Catalog : (class$com$sun$xml$tree$XmlDocument$Catalog = XmlDocument.class$("com.sun.xml.tree.XmlDocument$Catalog")));
        }
    }
}

