/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class BooleanConverter
implements Converter {
    private Object defaultValue = null;

    public BooleanConverter() {
        this(null);
    }

    public BooleanConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        try {
            String stringValue = (String)value;
            if (stringValue.equalsIgnoreCase("yes") || stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("on")) {
                return Boolean.TRUE;
            }
            if (stringValue.equalsIgnoreCase("no") || stringValue.equalsIgnoreCase("false") || stringValue.equalsIgnoreCase("off")) {
                return Boolean.FALSE;
            }
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw new ConversionException(stringValue);
        }
        catch (ClassCastException e) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

