/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class StackKeyedObjectPool
implements KeyedObjectPool {
    protected static final int DEFAULT_MAX_SLEEPING = 8;
    protected static final int DEFAULT_INIT_SLEEPING_CAPACITY = 4;
    protected HashMap _pools = null;
    protected KeyedPoolableObjectFactory _factory = null;
    protected int _maxSleeping = 8;
    protected int _initSleepingCapacity = 4;
    protected int _totActive = 0;
    protected int _totIdle = 0;
    protected HashMap _activeCount = null;

    public StackKeyedObjectPool() {
        this(null, 8, 4);
    }

    public StackKeyedObjectPool(int n) {
        this(null, n, 4);
    }

    public StackKeyedObjectPool(int n, int n2) {
        this(null, n, n2);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory) {
        this(keyedPoolableObjectFactory, 8);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n) {
        this(keyedPoolableObjectFactory, n, 4);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n, int n2) {
        this._factory = keyedPoolableObjectFactory;
        this._maxSleeping = n < 0 ? 8 : n;
        this._initSleepingCapacity = n2 < 1 ? 4 : n2;
        this._pools = new HashMap();
        this._activeCount = new HashMap();
    }

    public synchronized Object borrowObject(Object object) throws Exception {
        Object object2 = null;
        Stack stack = (Stack)this._pools.get(object);
        if (null == stack) {
            stack = new Stack();
            stack.ensureCapacity(this._initSleepingCapacity > this._maxSleeping ? this._maxSleeping : this._initSleepingCapacity);
            this._pools.put(object, stack);
            this._activeCount.put(object, new Integer(0));
        }
        try {
            object2 = stack.pop();
            --this._totIdle;
        }
        catch (Exception exception) {
            if (null == this._factory) {
                throw new NoSuchElementException();
            }
            object2 = this._factory.makeObject(object);
        }
        if (null != object2 && null != this._factory) {
            this._factory.activateObject(object, object2);
        }
        ++this._totActive;
        Integer n = (Integer)this._activeCount.get(object);
        this._activeCount.put(object, new Integer(n + 1));
        return object2;
    }

    public synchronized void returnObject(Object object, Object object2) throws Exception {
        Serializable serializable;
        --this._totActive;
        if (null == this._factory || this._factory.validateObject(object, object2)) {
            serializable = (Stack)this._pools.get(object);
            if (null == serializable) {
                serializable = new Stack();
                ((Vector)serializable).ensureCapacity(this._initSleepingCapacity > this._maxSleeping ? this._maxSleeping : this._initSleepingCapacity);
                this._pools.put(object, serializable);
                this._activeCount.put(object, new Integer(1));
            }
            if (null != this._factory) {
                try {
                    this._factory.passivateObject(object, object2);
                }
                catch (Exception exception) {
                    this._factory.destroyObject(object, object2);
                    return;
                }
            }
            if (((Vector)serializable).size() < this._maxSleeping) {
                ((Stack)serializable).push(object2);
                ++this._totIdle;
            } else if (null != this._factory) {
                this._factory.destroyObject(object, object2);
            }
        } else if (null != this._factory) {
            this._factory.destroyObject(object, object2);
        }
        serializable = (Integer)this._activeCount.get(object);
        this._activeCount.put(object, new Integer((Integer)serializable - 1));
    }

    public int numIdle() {
        return this._totIdle;
    }

    public int numActive() {
        return this._totActive;
    }

    public int numActive(Object object) {
        try {
            return (Integer)this._activeCount.get(object);
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public synchronized int numIdle(Object object) {
        try {
            return ((Stack)this._pools.get(object)).size();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public synchronized void clear() {
        Iterator iterator = this._pools.keySet().iterator();
        while (iterator.hasNext()) {
            this.clear(iterator.next());
        }
        this._totIdle = 0;
        this._pools.clear();
        this._activeCount.clear();
    }

    public synchronized void clear(Object object) {
        Stack stack = (Stack)this._pools.remove(object);
        if (null == stack) {
            return;
        }
        Enumeration enumeration = stack.elements();
        while (enumeration.hasMoreElements()) {
            try {
                this._factory.destroyObject(object, enumeration.nextElement());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._totIdle -= stack.size();
        this._activeCount.put(object, new Integer(0));
        stack.clear();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" contains ").append(this._pools.size()).append(" distinct pools: ");
        Iterator iterator = this._pools.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append(" |").append(k).append("|=");
            Stack stack = (Stack)this._pools.get(k);
            stringBuffer.append(stack.size());
        }
        return stringBuffer.toString();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pools = null;
        this._factory = null;
        this._activeCount = null;
    }

    public synchronized void setFactory(KeyedPoolableObjectFactory keyedPoolableObjectFactory) throws IllegalStateException {
        if (0 < this.numActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = keyedPoolableObjectFactory;
    }
}

