/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ClassCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.FieldInfoList;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.InterfaceList;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.MethodInfo;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.MethodInfoList;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.Utils;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.AttributeInfoList;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.LineNumberTable;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.SourceDir;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.SourceFile;

public class ClassFile {
    protected ConstantPool constantPool;
    protected InterfaceList interfaces;
    protected FieldInfoList fields;
    protected MethodInfoList methods;
    protected String sourceDir;
    protected String sourceFile;
    protected int access_flags;
    protected int this_class;
    protected int super_class;
    protected boolean isSynthetic;
    protected boolean isDeprecated;

    public ClassFile(InputStream is) throws IOException {
        SourceDir srcDir;
        DataInputStream dis = new DataInputStream(is);
        this.constantPool = new ConstantPool();
        int magic = dis.readInt();
        short minor = dis.readShort();
        short major = dis.readShort();
        this.constantPool.read(dis);
        this.constantPool.resolve();
        this.access_flags = dis.readShort();
        this.this_class = dis.readShort();
        this.super_class = dis.readShort();
        this.interfaces = new InterfaceList(this.constantPool);
        this.interfaces.read(dis);
        this.fields = new FieldInfoList(this.constantPool);
        this.fields.read(dis);
        this.methods = new MethodInfoList(this.constantPool);
        this.methods.read(dis);
        AttributeInfoList attributes = new AttributeInfoList(this.constantPool);
        attributes.read(dis);
        SourceFile srcFile = (SourceFile)attributes.getAttribute("SourceFile");
        if (srcFile != null) {
            this.sourceFile = srcFile.getValue();
        }
        if ((srcDir = (SourceDir)attributes.getAttribute("SourceDir")) != null) {
            this.sourceDir = srcDir.getValue();
        }
        this.isSynthetic = attributes.getAttribute("Synthetic") != null;
        this.isDeprecated = attributes.getAttribute("Deprecated") != null;
    }

    public int getAccess() {
        return this.access_flags;
    }

    public InterfaceList getInterfaces() {
        return this.interfaces;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public MethodInfoList getMethods() {
        return this.methods;
    }

    public FieldInfoList getFields() {
        return this.fields;
    }

    public String getSuperName() {
        return Utils.getUTF8Value(this.constantPool, this.super_class);
    }

    public String getFullName() {
        return ((ClassCPInfo)this.constantPool.getEntry(this.this_class)).getClassName().replace('/', '.');
    }

    public String getName() {
        String name = this.getFullName();
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return name.substring(pos + 1);
    }

    public String getPackage() {
        String name = this.getFullName();
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return name.substring(0, pos);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("loading classfile...");
        InputStream is = ClassLoader.getSystemResourceAsStream("java/util/Vector.class");
        ClassFile clazzfile = new ClassFile(is);
        System.out.println("Class name: " + clazzfile.getName());
        MethodInfoList methods = clazzfile.getMethods();
        int i = 0;
        while (i < methods.length()) {
            MethodInfo method = methods.getMethod(i);
            System.out.println("Method: " + method.getFullSignature());
            System.out.println("line: " + method.getNumberOfLines());
            LineNumberTable lnt = method.getCode().getLineNumberTable();
            ++i;
        }
    }
}

