/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

public class OpMap {
    protected String m_currentPattern;
    static final int MAXTOKENQUEUESIZE = 500;
    public Object[] m_tokenQueue = new Object[500];
    public int m_tokenQueueSize = 0;
    public int[] m_opMap = null;
    public static final int MAPINDEX_LENGTH = 1;

    public int getArgLength(int opPos) {
        return this.m_opMap[opPos + 1];
    }

    public int getArgLengthOfStep(int opPos) {
        return this.m_opMap[opPos + 1 + 1] - 3;
    }

    public static int getFirstChildPos(int opPos) {
        return opPos + 2;
    }

    public static int getFirstChildPosOfStep(int opPos) {
        return opPos + 3;
    }

    public int getFirstPredicateOpPos(int opPos) {
        int stepType = this.m_opMap[opPos];
        if (stepType >= 37 && stepType <= 53) {
            return opPos + this.m_opMap[opPos + 2];
        }
        if (stepType >= 22 && stepType <= 25) {
            return opPos + this.m_opMap[opPos + 1];
        }
        throw new RuntimeException("Programmer's assertion in getNextStepPos: unknown stepType: " + stepType);
    }

    public int getNextOpPos(int opPos) {
        return opPos + this.m_opMap[opPos + 1];
    }

    public static int getNextOpPos(int[] opMap, int opPos) {
        return opPos + opMap[opPos + 1];
    }

    public int getNextStepPos(int opPos) {
        int stepType = this.getOp(opPos);
        if (stepType >= 37 && stepType <= 53) {
            return this.getNextOpPos(opPos);
        }
        if (stepType >= 22 && stepType <= 25) {
            int newOpPos = this.getNextOpPos(opPos);
            while (this.getOp(newOpPos) == 29) {
                newOpPos = this.getNextOpPos(newOpPos);
            }
            stepType = this.getOp(newOpPos);
            if (stepType < 37 || stepType > 53) {
                return -1;
            }
            return newOpPos;
        }
        throw new RuntimeException("Programmer's assertion in getNextStepPos: unknown stepType: " + stepType);
    }

    public int getOp(int opPos) {
        return this.m_opMap[opPos];
    }

    public int[] getOpMap() {
        return this.m_opMap;
    }

    public String getPatternString() {
        return this.m_currentPattern;
    }

    public String getStepLocalName(int opPosOfStep) {
        int index;
        int argLenOfStep = this.getArgLengthOfStep(opPosOfStep);
        switch (argLenOfStep) {
            case 0: {
                index = -2;
                break;
            }
            case 1: {
                index = -3;
                break;
            }
            case 2: {
                index = this.m_opMap[opPosOfStep + 4];
                break;
            }
            case 3: {
                index = this.m_opMap[opPosOfStep + 5];
                break;
            }
            default: {
                index = -2;
            }
        }
        if (index >= 0) {
            return this.m_tokenQueue[index].toString();
        }
        if (index == -3) {
            return "*";
        }
        return null;
    }

    public String getStepNS(int opPosOfStep) {
        int argLenOfStep = this.getArgLengthOfStep(opPosOfStep);
        if (argLenOfStep == 3) {
            int index = this.m_opMap[opPosOfStep + 4];
            if (index >= 0) {
                return (String)this.m_tokenQueue[index];
            }
            if (index == -3) {
                return "*";
            }
            return null;
        }
        return null;
    }

    public int getStepTestType(int opPosOfStep) {
        return this.m_opMap[opPosOfStep + 3];
    }

    public Object getToken(int pos) {
        return this.m_tokenQueue[pos];
    }

    public Object[] getTokenQueue() {
        return this.m_tokenQueue;
    }

    public int getTokenQueueSize() {
        return this.m_tokenQueueSize;
    }

    void shrink() {
        int[] map = this.m_opMap;
        int n = this.m_opMap[1];
        this.m_opMap = new int[n + 4];
        int i = 0;
        while (i < n) {
            this.m_opMap[i] = map[i];
            ++i;
        }
        this.m_opMap[i] = 0;
        this.m_opMap[i + 1] = 0;
        this.m_opMap[i + 2] = 0;
        Object[] tokens = this.m_tokenQueue;
        n = this.m_tokenQueueSize;
        this.m_tokenQueue = new Object[n + 4];
        i = 0;
        while (i < n) {
            this.m_tokenQueue[i] = tokens[i];
            ++i;
        }
        this.m_tokenQueue[i] = null;
        this.m_tokenQueue[i + 1] = null;
        this.m_tokenQueue[i + 2] = null;
    }

    public String toString() {
        return this.m_currentPattern;
    }
}

