/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Stack;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.ReverseAxesWalker;
import org.w3c.dom.Node;

public class AncestorWalker
extends ReverseAxesWalker {
    protected transient Stack m_ancestors;
    protected transient int m_ancestorsPos;

    public AncestorWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Object clone() throws CloneNotSupportedException {
        AncestorWalker clone = (AncestorWalker)super.clone();
        return clone;
    }

    public Node firstChild() {
        Node next = this.m_ancestorsPos < 0 ? null : (Node)this.m_ancestors.elementAt(this.m_ancestorsPos--);
        this.m_nextLevelAmount = this.m_ancestorsPos < 0 ? 0 : 1;
        return this.setCurrentIfNotNull(next);
    }

    protected int getLevelMax() {
        DOMHelper dh = this.m_lpi.getDOMHelper();
        Node p = dh.getParentOfNode(this.m_root);
        return p == null ? 1 : (int)dh.getLevel(p);
    }

    protected void pushAncestors(Node n) {
        this.m_ancestors = new Stack();
        DOMHelper dh = this.m_lpi.getDOMHelper();
        while ((n = dh.getParentOfNode(n)) != null) {
            this.m_ancestors.push(n);
        }
        this.m_nextLevelAmount = this.m_ancestors.isEmpty() ? 0 : 1;
        this.m_ancestorsPos = this.m_ancestors.size() - 1;
    }

    public void setRoot(Node root) {
        this.pushAncestors(root);
        super.setRoot(root);
    }
}

