/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.xml.utils.NodeVector;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSet
extends NodeVector
implements NodeList,
NodeIterator,
Cloneable,
ContextNodeList {
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    private transient int m_last = 0;

    public NodeSet() {
    }

    public NodeSet(int blocksize) {
        super(blocksize);
    }

    public NodeSet(NodeSet nodelist) {
        this.addNodes((NodeIterator)nodelist);
    }

    public NodeSet(Node node) {
        this.addNode(node);
    }

    public NodeSet(NodeList nodelist) {
        this.addNodes(nodelist);
    }

    public NodeSet(NodeIterator ni) {
        this.addNodes(ni);
    }

    public void addElement(Node value) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.addElement(value);
    }

    public void addNode(Node n) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.addElement(n);
    }

    public int addNodeInDocOrder(Node node, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        return this.addNodeInDocOrder(node, true, support);
    }

    public int addNodeInDocOrder(Node node, boolean test, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        int insertIndex = -1;
        if (test) {
            int size = this.size();
            int i = size - 1;
            while (i >= 0) {
                Node child = this.elementAt(i);
                if (child == node) {
                    i = -2;
                    break;
                }
                if (!support.getDOMHelper().isNodeAfter(node, child)) break;
                --i;
            }
            if (i != -2) {
                insertIndex = i + 1;
                this.insertElementAt(node, insertIndex);
            }
        } else {
            insertIndex = this.size();
            boolean foundit = false;
            int i = 0;
            while (i < insertIndex) {
                if (this.item(i).equals(node)) {
                    foundit = true;
                    break;
                }
                ++i;
            }
            if (!foundit) {
                this.addElement(node);
            }
        }
        return insertIndex;
    }

    public void addNodes(NodeSet ns) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.addNodes((NodeIterator)ns);
    }

    public void addNodes(NodeList nodelist) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        if (nodelist != null) {
            int nChildren = nodelist.getLength();
            int i = 0;
            while (i < nChildren) {
                Node obj = nodelist.item(i);
                if (obj != null) {
                    this.addElement(obj);
                }
                ++i;
            }
        }
    }

    public void addNodes(NodeIterator iterator) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        if (iterator != null) {
            Node obj;
            while ((obj = iterator.nextNode()) != null) {
                this.addElement(obj);
            }
        }
    }

    private boolean addNodesInDocOrder(int start, int end, int testIndex, NodeList nodelist, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        boolean foundit = false;
        Node node = nodelist.item(testIndex);
        int i = end;
        while (i >= start) {
            Node child = this.elementAt(i);
            if (child == node) {
                i = -2;
                break;
            }
            if (!support.getDOMHelper().isNodeAfter(node, child)) {
                boolean foundPrev;
                this.insertElementAt(node, i + 1);
                if (--testIndex <= 0 || (foundPrev = this.addNodesInDocOrder(0, i, testIndex, nodelist, support))) break;
                this.addNodesInDocOrder(i, this.size() - 1, testIndex, nodelist, support);
                break;
            }
            --i;
        }
        if (i == -1) {
            this.insertElementAt(node, 0);
        }
        return foundit;
    }

    public void addNodesInDocOrder(NodeList nodelist, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        int nChildren = nodelist.getLength();
        int i = 0;
        while (i < nChildren) {
            Node node = nodelist.item(i);
            if (node != null) {
                this.addNodeInDocOrder(node, support);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addNodesInDocOrder(NodeIterator iterator, XPathContext support) {
        if (this.m_mutable) ** GOTO lbl5
        throw new RuntimeException("This NodeSet is not mutable!");
lbl-1000:
        // 1 sources

        {
            this.addNodeInDocOrder(node, support);
lbl5:
            // 2 sources

            ** while ((node = iterator.nextNode()) != null)
        }
lbl6:
        // 1 sources

    }

    public void appendNodes(NodeVector nodes) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.appendNodes(nodes);
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSet clone = (NodeSet)super.clone();
        return clone;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSet clone = (NodeSet)this.clone();
        clone.reset();
        return clone;
    }

    public boolean contains(Node s) {
        this.runTo(-1);
        return super.contains(s);
    }

    public void detach() {
    }

    public Node elementAt(int i) {
        this.runTo(i);
        return super.elementAt(i);
    }

    public Node getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        int saved = this.m_next;
        Node n = this.elementAt(this.m_next - 1);
        this.m_next = saved;
        return n;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public Node getRoot() {
        return null;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public int getWhatToShow() {
        return -17;
    }

    public int indexOf(Node elem) {
        this.runTo(-1);
        return super.indexOf(elem);
    }

    public int indexOf(Node elem, int index) {
        this.runTo(-1);
        return super.indexOf(elem, index);
    }

    public void insertElementAt(Node value, int at) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.insertElementAt(value, at);
    }

    public void insertNode(Node n, int pos) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.insertElementAt(n, pos);
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public Node item(int index) {
        this.runTo(index);
        return this.elementAt(index);
    }

    public Node nextNode() throws DOMException {
        if (this.m_next < this.size()) {
            Node next = this.elementAt(this.m_next);
            ++this.m_next;
            return next;
        }
        return null;
    }

    public Node previousNode() throws DOMException {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return null;
    }

    public void removeAllElements() {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.removeAllElements();
    }

    public boolean removeElement(Node s) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        return super.removeElement(s);
    }

    public void removeElementAt(int i) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.removeElementAt(i);
    }

    public void removeNode(Node n) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.removeElement(n);
    }

    public void reset() {
        this.m_next = 0;
    }

    public void runTo(int index) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = index >= 0 && this.m_next < this.m_firstFree ? index : this.m_firstFree - 1;
    }

    public void setCurrentPos(int i) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = i;
    }

    public void setElementAt(Node node, int index) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.setElementAt(node, index);
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public void setShouldCacheNodes(boolean b) {
        if (!this.isFresh()) {
            throw new RuntimeException("Can not call setShouldCacheNodes after nextNode has been called!");
        }
        this.m_cacheNodes = b;
        this.m_mutable = true;
    }

    public int size() {
        return super.size();
    }
}

