/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory {
    protected ConnectionFactory _connFactory = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected KeyedObjectPoolFactory _stmtPoolFactory = null;
    protected boolean _defaultReadOnly = false;
    protected boolean _defaultAutoCommit = true;

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, boolean bl, boolean bl2) throws Exception {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl;
        this._defaultAutoCommit = bl2;
    }

    public synchronized void setConnectionFactory(ConnectionFactory connectionFactory) {
        this._connFactory = connectionFactory;
    }

    public synchronized void setValidationQuery(String string) {
        this._validationQuery = string;
    }

    public synchronized void setPool(ObjectPool objectPool) {
        if (null != this._pool && objectPool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = objectPool;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized void setStatementPoolFactory(KeyedObjectPoolFactory keyedObjectPoolFactory) {
        this._stmtPoolFactory = keyedObjectPoolFactory;
    }

    public void setDefaultReadOnly(boolean bl) {
        this._defaultReadOnly = bl;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this._defaultAutoCommit = bl;
    }

    public synchronized Object makeObject() throws Exception {
        Connection connection = this._connFactory.createConnection();
        try {
            connection.setAutoCommit(this._defaultAutoCommit);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            connection.setReadOnly(this._defaultReadOnly);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (null != this._stmtPoolFactory) {
            KeyedObjectPool keyedObjectPool = this._stmtPoolFactory.createPool();
            connection = new PoolingConnection(connection, keyedObjectPool);
            keyedObjectPool.setFactory((KeyedPoolableObjectFactory)((PoolingConnection)connection));
        }
        return new PoolableConnection(connection, this._pool);
    }

    public void destroyObject(Object object) throws Exception {
        if (object instanceof PoolableConnection) {
            try {
                ((PoolableConnection)object).reallyClose();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean validateObject(Object object) {
        if (object instanceof Connection) {
            String string = this._validationQuery;
            Connection connection = (Connection)object;
            try {
                if (connection.isClosed()) {
                    return false;
                }
            }
            catch (SQLException sQLException) {
                return false;
            }
            if (null != string) {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    return resultSet.next();
                }
                catch (Exception exception) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        statement.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void passivateObject(Object object) throws Exception {
        if (object instanceof Connection) {
            Connection connection = (Connection)object;
            try {
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                connection.setAutoCommit(this._defaultAutoCommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                connection.setReadOnly(this._defaultReadOnly);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (object instanceof DelegatingConnection) {
            ((DelegatingConnection)object).passivate();
        }
    }

    public void activateObject(Object object) throws Exception {
        if (object instanceof DelegatingConnection) {
            ((DelegatingConnection)object).activate();
        }
        if (object instanceof Connection) {
            Connection connection = (Connection)object;
            try {
                connection.setAutoCommit(this._defaultAutoCommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                connection.setReadOnly(this._defaultReadOnly);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

