/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DelegatingPreparedStatement
implements PreparedStatement {
    protected PreparedStatement _stmt = null;
    protected boolean _closed = false;

    public DelegatingPreparedStatement(PreparedStatement preparedStatement) {
        this._stmt = preparedStatement;
    }

    public PreparedStatement getDelegate() {
        return this._stmt;
    }

    public PreparedStatement getInnermostDelegate() {
        PreparedStatement preparedStatement = this._stmt;
        while (preparedStatement != null && preparedStatement instanceof DelegatingPreparedStatement) {
            if (this != (preparedStatement = ((DelegatingPreparedStatement)preparedStatement).getDelegate())) continue;
            return null;
        }
        return preparedStatement;
    }

    public void setDelegate(PreparedStatement preparedStatement) {
        this._stmt = preparedStatement;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.checkOpen();
        return this._stmt.executeQuery(string);
    }

    public int executeUpdate(String string) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(string);
    }

    public void close() throws SQLException {
        this.passivate();
        this._stmt.close();
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxFieldSize(n);
    }

    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxRows(n);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkOpen();
        this._stmt.setEscapeProcessing(bl);
    }

    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this._stmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setQueryTimeout(n);
    }

    public void cancel() throws SQLException {
        this.checkOpen();
        this._stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._stmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._stmt.clearWarnings();
    }

    public void setCursorName(String string) throws SQLException {
        this.checkOpen();
        this._stmt.setCursorName(string);
    }

    public boolean execute(String string) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(string);
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this._stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return this._stmt.getMoreResults();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetType();
    }

    public void addBatch(String string) throws SQLException {
        this.checkOpen();
        this._stmt.addBatch(string);
    }

    public void clearBatch() throws SQLException {
        this.checkOpen();
        this._stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return this._stmt.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._stmt.getConnection();
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        return this._stmt.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkOpen();
        this._stmt.setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkOpen();
        this._stmt.setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkOpen();
        this._stmt.setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkOpen();
        this._stmt.setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkOpen();
        this._stmt.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkOpen();
        this._stmt.setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkOpen();
        this._stmt.setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkOpen();
        this._stmt.setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkOpen();
        this._stmt.setBigDecimal(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.checkOpen();
        this._stmt.setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkOpen();
        this._stmt.setBytes(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkOpen();
        this._stmt.setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkOpen();
        this._stmt.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkOpen();
        this._stmt.setTimestamp(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        this._stmt.setAsciiStream(n, inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        this._stmt.setUnicodeStream(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        this._stmt.setBinaryStream(n, inputStream, n2);
    }

    public void clearParameters() throws SQLException {
        this.checkOpen();
        this._stmt.clearParameters();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkOpen();
        this._stmt.setObject(n, object, n2, n3);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkOpen();
        this._stmt.setObject(n, object, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkOpen();
        this._stmt.setObject(n, object);
    }

    public boolean execute() throws SQLException {
        this.checkOpen();
        return this._stmt.execute();
    }

    public void addBatch() throws SQLException {
        this.checkOpen();
        this._stmt.addBatch();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkOpen();
        this._stmt.setCharacterStream(n, reader, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkOpen();
        this._stmt.setRef(n, ref);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkOpen();
        this._stmt.setBlob(n, blob);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkOpen();
        this._stmt.setClob(n, clob);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkOpen();
        this._stmt.setArray(n, array);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this._stmt.getMetaData();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkOpen();
        this._stmt.setDate(n, date, calendar);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkOpen();
        this._stmt.setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkOpen();
        this._stmt.setTimestamp(n, timestamp, calendar);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkOpen();
        this._stmt.setNull(n, n2, string);
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    protected void activate() {
        this._closed = false;
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).activate();
        }
    }

    protected void passivate() {
        this._closed = true;
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).passivate();
        }
    }
}

