/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysql;
import gwe.sql.gweMysqlMetaResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class gweMysqlResultSetCore
implements ResultSet {
    private gweMysql result;
    private gweMysqlMetaResult meta;
    private Hashtable columnName;
    private Hashtable columnFullName;
    private int last_read = -1;
    private int resultSetType;
    private int resultSetConcurrency;
    private int fetchDirection;
    private int fetchSize;
    private Statement statement;
    private boolean packet_done = false;

    public gweMysqlResultSetCore(gweMysql gweMysql2, Statement statement, int n, int n2) {
        this.result = gweMysql2;
        this.statement = statement;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.fetchDirection = 1002;
        this.fetchSize = 0;
        this.meta = new gweMysqlMetaResult(this.result);
        this.columnName = (Hashtable)this.result.columnName.clone();
        this.columnFullName = (Hashtable)this.result.columnFullName.clone();
    }

    public synchronized boolean next() throws SQLException {
        if (this.packet_done) {
            return false;
        }
        try {
            this.last_read = -1;
            boolean bl = this.result.nextResult();
            if (!bl) {
                this.packet_done = true;
            }
            return bl;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public boolean isNull(int n) throws SQLException {
        try {
            return this.result.isNull(n);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public boolean wasNull() throws SQLException {
        if (this.last_read == -1) {
            return false;
        }
        return this.isNull(this.last_read);
    }

    public String getString(int n) throws SQLException {
        this.last_read = n;
        if (this.isNull(n)) {
            return null;
        }
        try {
            try {
                byte[] byArray = this.result.getBytes(n);
                int n2 = byArray.length;
                String string = this.result.getEncoding();
                String string2 = "";
                while (n2 > 0) {
                    string2 = new String(byArray, 0, n2, string);
                    if (string2.length() > 0) break;
                    --n2;
                }
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return this.result.getString(n);
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public byte getByte(int n) throws SQLException {
        this.last_read = n;
        if (this.isNull(n)) {
            return 0;
        }
        try {
            String string = this.result.getString(n);
            if (string.equals("")) {
                return 0;
            }
            return (byte)Integer.valueOf(string).intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        this.last_read = n;
        if (this.isNull(n)) {
            return false;
        }
        try {
            String string = this.result.getString(n);
            if (string.equals("")) {
                return false;
            }
            if (string.equals("0")) {
                return false;
            }
            if (string.equals("N")) {
                return false;
            }
            return !string.equals("n");
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0;
            }
            return (short)Integer.valueOf(string).intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0;
            }
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0L;
            }
            return Long.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0.0f;
            }
            return Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0.0;
            }
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return new BigDecimal(new BigInteger("0"), n2);
            }
            return new BigDecimal(new BigInteger(string), n2);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            this.last_read = n;
            return this.result.getBytes(n);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return null;
            }
            return Date.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return null;
            }
            return Time.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return null;
            }
            try {
                return Timestamp.valueOf(string);
            }
            catch (Exception exception) {
                Integer n2 = new Integer(string.substring(0, 4));
                Integer n3 = new Integer(string.substring(4, 6));
                Integer n4 = new Integer(string.substring(6, 8));
                Integer n5 = new Integer(string.substring(8, 10));
                Integer n6 = new Integer(string.substring(10, 12));
                Integer n7 = new Integer(string.substring(12, 14));
                return new Timestamp(n2 - 1900, n3 - 1, n4, n5, n6, n7, 0);
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return null;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            byte[] byArray = this.getBytes(n);
            if (byArray == null) {
                return null;
            }
            return new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void close() throws SQLException {
        try {
            if (!this.packet_done) {
                while (this.next()) {
                }
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.meta;
    }

    public Object getObject(int n, int n2, int n3) throws SQLException {
        switch (n2) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                return new Byte((byte)this.getInt(n));
            }
            case 5: {
                return new Integer(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 2: {
                return this.getBigDecimal(n, n3);
            }
            case 3: {
                return this.getBigDecimal(n, n3);
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBytes(n);
            }
        }
        return null;
    }

    public Object getObject(int n, int n2) throws SQLException {
        return this.getObject(n, n2, 10);
    }

    public Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        return this.getObject(n, n2);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Object getObject(String string, int n, int n2) throws SQLException {
        return this.getObject(this.findColumn(string), n, n2);
    }

    public Object getObject(String string, int n) throws SQLException {
        return this.getObject(this.findColumn(string), n, 0);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public boolean isNull(String string) throws SQLException {
        return this.isNull(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        try {
            Integer n = (Integer)this.columnName.get(string);
            if (n == null) {
                n = (Integer)this.columnFullName.get(string);
            }
            if (n != null) {
                return n + 1;
            }
            throw new SQLException("Invalid column name : " + string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    String getEncoding() {
        return this.result.getEncoding();
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return null;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 10);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("mysql does not support isBeforeFirst().");
    }

    public boolean isAfterLast() throws SQLException {
        throw new SQLException("mysql does not support isAfterLast().");
    }

    public boolean isFirst() throws SQLException {
        throw new SQLException("mysql does not support isFirst().");
    }

    public boolean isLast() throws SQLException {
        throw new SQLException("mysql does not support isLast().");
    }

    public void beforeFirst() throws SQLException {
        throw new SQLException("mysql does not support beforeFirst().");
    }

    public void afterLast() throws SQLException {
        throw new SQLException("mysql does not support afterLast().");
    }

    public boolean first() throws SQLException {
        throw new SQLException("mysql does not support first().");
    }

    public boolean last() throws SQLException {
        throw new SQLException("mysql does not support last().");
    }

    public int getRow() throws SQLException {
        return 0;
    }

    public boolean absolute(int n) throws SQLException {
        throw new SQLException("mysql does not support absolute(int).");
    }

    public boolean relative(int n) throws SQLException {
        throw new SQLException("mysql does not support relative(int).");
    }

    public boolean previous() throws SQLException {
        throw new SQLException("mysql does not support previous().");
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return this.resultSetType;
    }

    public int getConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("mysql does not support rowUpdated().");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("mysql does not support rowInserted().");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("mysql does not support rowDeleted().");
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException("mysql does not support updateNull(int).");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("mysql does not support updateBoolean(int, boolean).");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("mysql does not support updateByte(int, byte).");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("mysql does not support updateShort(int, short).");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateInt(int, int).");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("mysql does not support updateLong(int, long).");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("mysql does not support updateFloat(int, float).");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("mysql does not support updateDouble(int, double).");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("mysql does not support updateBigDecimal(int, BigDecimal).");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("mysql does not support updateString(int, String).");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("mysql does not support updateBytes(int, byte[]).");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("mysql does not support updateDate(int, Date).");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("mysql does not support updateTime(int, Time).");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("mysql does not support updateTimestamp(int, Timestamp).");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateAsciiStream(int, InputStream, int).");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateBinaryStream(int, InputStream, int).");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateCharacterStream(int, Reader, int).");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateObject(int, Object, int).");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("mysql does not support updateObject(int, Object).");
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException("mysql does not support updateNull(String).");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("mysql does not support updateBoolean(String, boolean).");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("mysql does not support updateByte(String, byte).");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("mysql does not support updateShort(String, short).");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("mysql does not support updateInt(String, int).");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("mysql does not support updateLong(String, long).");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("mysql does not support updateFloat(String, float).");
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("mysql does not support updateDouble(String, double).");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("mysql does not support updateBigDecimal(String, BigDecimal).");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("mysql does not support updateString(String, String).");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("mysql does not support updateBytes(String, byte[]).");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("mysql does not support updateDate(String, Date).");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("mysql does not support updateTime(String, Time).");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("mysql does not support updateTimestamp(String, Timestamp).");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("mysql does not support updateAsciiStream(String, InputStream, int).");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("mysql does not support updateBinaryStream(String, InputStream, int).");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("mysql does not support updateCharacterStream(String, Reader, int).");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("mysql does not support updateObject(String, Object, int).");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("mysql does not support updateObject(String, Object).");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("mysql does not support insertRow().");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("mysql does not support updateRow().");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("mysql does not support deleteRow().");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("mysql does not support refreshRow().");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("mysql does not support cancelRowUpdates().");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("mysql does not support moveToInsertRow().");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("mysql does not support moveToCurrentRow().");
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("mysql does not support getObject(int, Map).");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("mysql does not support getRef(int).");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("mysql does not support getBlob(int).");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("mysql does not support getClob(int).");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("mysql does not support getArray(int).");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("mysql does not support getObject(String, Map).");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("mysql does not support getRef(String).");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("mysql does not support getBlob(String).");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("mysql does not support getClob(String).");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("mysql does not support getArray(String).");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("mysql does not support getURL(int).");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("mysql does not support getURL(String).");
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("mysql does not support updateRef(int, Ref).");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("mysql does not support updateRef(String, Ref).");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("mysql does not support updateBlob(int, Blob).");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("mysql does not support updateBlob(String, Blob).");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("mysql does not support updateClob(int, Blob).");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("mysql does not support updateClob(String, Blob).");
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("mysql does not support updateArray(int, Array).");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException("mysql does not support updateArray(String, Array).");
    }
}

