/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysqlException;
import gwe.sql.gweMysqlPacket;
import gwe.sql.gweMysqlStringBuffer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

class gweMysqlPacketChannel
implements gweMysqlPacket {
    ReadableByteChannel readchannel;
    WritableByteChannel writechannel;
    byte packetSequence;
    int bpos_w;
    int bpos_r;
    int packetLength_r;
    public boolean TRACING = false;
    ByteBuffer bbuffer_w;
    ByteBuffer bbuffer_r;
    String encoding;

    public gweMysqlPacketChannel(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel, String string) {
        this.readchannel = readableByteChannel;
        this.writechannel = writableByteChannel;
        this.encoding = string;
        this.bbuffer_w = ByteBuffer.allocateDirect(65535);
        this.bbuffer_r = ByteBuffer.allocateDirect(65535);
    }

    public void resetPacketSequence() {
        this.packetSequence = (byte)-1;
    }

    public void next() throws gweMysqlException {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            int n = this.readchannel.read(byteBuffer);
            this.packetLength_r = this.ub(byteBuffer.get(0)) + 256 * this.ub(byteBuffer.get(1)) + 65536 * this.ub(byteBuffer.get(2));
            this.packetSequence = byteBuffer.get(3);
            if (this.TRACING) {
                System.out.println("Packet length = " + this.packetLength_r);
                System.out.println("Packet sequence = " + this.packetSequence);
            }
            if (this.bbuffer_r.capacity() < this.packetLength_r + 1) {
                this.bbuffer_r = ByteBuffer.allocateDirect(this.packetLength_r + 1);
            }
            this.bbuffer_r.position(0);
            this.bbuffer_r.limit(this.packetLength_r);
            int n2 = this.readchannel.read(this.bbuffer_r);
            this.bbuffer_r.position(0);
            this.bbuffer_r.limit(this.bbuffer_r.capacity());
            this.bbuffer_r.put(this.packetLength_r, (byte)0);
            this.bpos_r = 0;
            if (this.TRACING) {
                int n3 = 0;
                while (n3 < this.packetLength_r) {
                    System.out.print(n3 + " : " + this.ub(this.bbuffer_r.get(n3)) + "  : ");
                    if (this.bbuffer_r.get(n3) > 30) {
                        System.out.println((char)this.bbuffer_r.get(n3));
                    } else {
                        System.out.println("");
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            throw new gweMysqlException("gweMysql.Next: " + exception);
        }
    }

    public int ub(byte n) {
        return n < 0 ? 256 + n : n;
    }

    public int currentPos_r() {
        return this.bpos_r;
    }

    public void setPos_r(int n) {
        this.bpos_r = n;
    }

    public byte getCurDataPos_r() {
        return this.bbuffer_r.get(this.bpos_r);
    }

    public byte readByte() {
        return this.bbuffer_r.get(this.bpos_r++);
    }

    public byte[] readByteBlock(int n) {
        byte[] byArray = new byte[n];
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = this.bbuffer_r.get(this.bpos_r);
                ++this.bpos_r;
                ++n2;
            }
        }
        return byArray;
    }

    public int read2Bytes() {
        return this.ub(this.bbuffer_r.get(this.bpos_r++)) + 256 * this.ub(this.bbuffer_r.get(this.bpos_r++));
    }

    public int read3Bytes() {
        return this.ub(this.bbuffer_r.get(this.bpos_r++)) + 256 * this.ub(this.bbuffer_r.get(this.bpos_r++)) + 65536 * this.ub(this.bbuffer_r.get(this.bpos_r++));
    }

    public long read4Bytes() {
        return this.ub(this.bbuffer_r.get(this.bpos_r++)) + 256 * this.ub(this.bbuffer_r.get(this.bpos_r++)) + 65536 * this.ub(this.bbuffer_r.get(this.bpos_r++)) + 0x1000000 * this.ub(this.bbuffer_r.get(this.bpos_r++));
    }

    public int readnBytes() {
        switch (this.ub(this.bbuffer_r.get(this.bpos_r++))) {
            case 1: {
                return this.ub(this.bbuffer_r.get(this.bpos_r++));
            }
            case 2: {
                return this.read2Bytes();
            }
            case 3: {
                return this.read3Bytes();
            }
            case 4: {
                return (int)this.read4Bytes();
            }
        }
        return 255;
    }

    public long readLength() {
        switch (this.ub(this.bbuffer_r.get(this.bpos_r))) {
            case 251: {
                ++this.bpos_r;
                return -1L;
            }
            case 252: {
                ++this.bpos_r;
                return this.read2Bytes();
            }
            case 253: {
                ++this.bpos_r;
                return this.read3Bytes();
            }
            case 254: {
                ++this.bpos_r;
                return this.read4Bytes();
            }
        }
        return this.ub(this.bbuffer_r.get(this.bpos_r++));
    }

    public String readString() {
        gweMysqlStringBuffer gweMysqlStringBuffer2 = new gweMysqlStringBuffer();
        int n = this.bpos_r;
        while (this.bbuffer_r.get(n) != 0) {
            gweMysqlStringBuffer2.append((char)this.bbuffer_r.get(n++));
        }
        this.bpos_r = n + 1;
        return gweMysqlStringBuffer2.toString();
    }

    public String readLenString() {
        long l = this.readLength();
        if (l == -1L) {
            return null;
        }
        if (l == 0L) {
            return "";
        }
        gweMysqlStringBuffer gweMysqlStringBuffer2 = new gweMysqlStringBuffer((int)l);
        int n = 0;
        while ((long)n < l) {
            if (this.bbuffer_r.get(this.bpos_r) == 0) break;
            gweMysqlStringBuffer2.append((char)this.bbuffer_r.get(this.bpos_r++));
            ++n;
        }
        return gweMysqlStringBuffer2.toString();
    }

    public boolean isLastDataPacket_r() {
        return this.packetLength_r == 1 && this.ub(this.bbuffer_r.get(0)) == 254;
    }

    public void clear_w() {
        this.bpos_w = 4;
    }

    public void send() {
        try {
            int n = this.bpos_w;
            this.bpos_w = 0;
            this.packetSequence = (byte)(this.packetSequence + 1);
            this.write3Bytes(n - 4);
            this.writeByte(this.packetSequence);
            if (this.TRACING) {
                int n2 = 0;
                while (n2 < n) {
                    System.out.print(n2 + " : " + this.ub(this.bbuffer_w.get(n2)) + "  : ");
                    if (this.bbuffer_w.get(n2) > 30) {
                        System.out.println((char)this.bbuffer_w.get(n2));
                    } else {
                        System.out.println("");
                    }
                    ++n2;
                }
            }
            this.bbuffer_w.position(0);
            this.bbuffer_w.limit(n);
            this.writechannel.write(this.bbuffer_w);
            this.bbuffer_w.position(0);
            this.bbuffer_w.limit(this.bbuffer_w.capacity());
        }
        catch (Exception exception) {
            System.out.println("send() Error : " + exception);
        }
    }

    public void writeByte(byte by) {
        this.bbuffer_w.put(this.bpos_w++, by);
    }

    public void write2Bytes(int n) {
        int n2 = n % 256;
        this.bbuffer_w.put(this.bpos_w++, (byte)n2);
        this.bbuffer_w.put(this.bpos_w++, (byte)(n /= 256));
    }

    public void write3Bytes(int n) {
        int n2 = n % 256;
        this.bbuffer_w.put(this.bpos_w++, (byte)n2);
        n2 = (n /= 256) % 256;
        this.bbuffer_w.put(this.bpos_w++, (byte)n2);
        this.bbuffer_w.put(this.bpos_w++, (byte)(n /= 256));
    }

    public void write4Bytes(long l) {
        long l2 = l % 256L;
        this.bbuffer_w.put(this.bpos_w++, (byte)l2);
        l2 = (l /= 256L) % 256L;
        this.bbuffer_w.put(this.bpos_w++, (byte)l2);
        l2 = (l /= 256L) % 256L;
        this.bbuffer_w.put(this.bpos_w++, (byte)l2);
        this.bbuffer_w.put(this.bpos_w++, (byte)(l /= 256L));
    }

    public void writeString(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.bbuffer_w.put(this.bpos_w++, (byte)string.charAt(n2));
            ++n2;
        }
        this.bbuffer_w.put(this.bpos_w++, (byte)0);
    }

    /*
     * Unable to fully structure code
     */
    public void writeStringNoNull(String var1_1) {
        block4: {
            try {
                var2_2 = var1_1.getBytes(this.encoding);
                var3_4 = var2_2.length;
                var4_6 = 0;
                while (var4_6 < var3_4) {
                    this.bbuffer_w.put(this.bpos_w++, var2_2[var4_6]);
                    ++var4_6;
                }
                break block4;
            }
            catch (UnsupportedEncodingException var2_3) {
                var3_5 = var1_1.length();
                var4_7 = 0;
                ** while (var4_7 < var3_5)
            }
lbl-1000:
            // 1 sources

            {
                this.bbuffer_w.put(this.bpos_w++, (byte)var1_1.charAt(var4_7));
                ++var4_7;
                continue;
            }
        }
    }

    public void sendHeader(int n) throws gweMysqlException {
        this.bpos_w = 0;
        this.packetSequence = 0;
        this.write3Bytes(1 + n);
        this.writeByte(this.packetSequence);
        this.writeByte((byte)3);
        try {
            this.bbuffer_w.position(0);
            this.bbuffer_w.limit(5);
            this.writechannel.write(this.bbuffer_w);
            this.bbuffer_w.position(0);
            this.bbuffer_w.limit(this.bbuffer_w.capacity());
            this.bpos_w = 0;
        }
        catch (IOException iOException) {
            throw new gweMysqlException("gweMysqlPacket.sendHeader: " + iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeStringNoNullandSendBuffer(String var1_1) throws gweMysqlException {
        block6: {
            try {
                var2_2 = var1_1.getBytes(this.encoding);
                var3_4 = var2_2.length;
                var4_6 = this.bbuffer_w.capacity();
                var5_8 = 0;
                while (var5_8 < var3_4) {
                    this.bbuffer_w.put(this.bpos_w++, var2_2[var5_8]);
                    if (this.bpos_w == var4_6) {
                        this.flushSendBuffer();
                    }
                    ++var5_8;
                }
                break block6;
            }
            catch (UnsupportedEncodingException var2_3) {
                var3_5 = var1_1.length();
                var4_7 = this.bbuffer_w.capacity();
                var5_9 = 0;
                ** while (var5_9 < var3_5)
            }
lbl-1000:
            // 1 sources

            {
                this.bbuffer_w.put(this.bpos_w++, (byte)var1_1.charAt(var5_9));
                if (this.bpos_w == var4_7) {
                    this.flushSendBuffer();
                }
                ++var5_9;
                continue;
            }
        }
    }

    public void writeStringNoNullandSendBufferEx(String string) throws gweMysqlException {
        int n = string.length();
        int n2 = this.bbuffer_w.capacity();
        int n3 = 0;
        while (n3 < n) {
            this.bbuffer_w.put(this.bpos_w++, (byte)string.charAt(n3));
            if (this.bpos_w == n2) {
                this.flushSendBuffer();
            }
            ++n3;
        }
    }

    public void flushSendBuffer() throws gweMysqlException {
        try {
            this.bbuffer_w.position(0);
            this.bbuffer_w.limit(this.bpos_w);
            this.writechannel.write(this.bbuffer_w);
            this.bbuffer_w.position(0);
            this.bbuffer_w.limit(this.bbuffer_w.capacity());
            this.bpos_w = 0;
        }
        catch (IOException iOException) {
            throw new gweMysqlException("gweMysqlPacket.writeStringNoNullandSendBuffer: " + iOException);
        }
    }
}

