/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.io.File;
import java.sql.Date;
import java.text.SimpleDateFormat;
import jp.sourceforge.akjrcp.ui.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FileOverwriteControler {
    private static final int YES = 0;
    private static final int YES_ALL = 1;
    private static final int NO = 2;
    private static final int CANCEL = 3;
    private boolean yesAll;
    private boolean canceled;
    public static final int MODE_ALL = 0;
    public static final int MODE_YES_NO_CANCEL = 1;
    private int mode;
    private int[] buttons;
    private Shell shell;
    public static final long GBYTE = 0x40000000L;
    public static final long MBYTE = 0x100000L;
    public static final long KBYTE = 1024L;

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public boolean isYesAll() {
        return this.yesAll;
    }

    public void setYesAll(boolean yesAll) {
        this.yesAll = yesAll;
    }

    public FileOverwriteControler(Shell shell) {
        this(shell, 0);
    }

    public FileOverwriteControler(Shell shell, int mode) {
        this.shell = shell;
        this.mode = mode;
        this.buttons = new int[4];
        if (mode == 0) {
            this.buttons[0] = 0;
            this.buttons[1] = 1;
            this.buttons[2] = 2;
            this.buttons[3] = 3;
        } else {
            this.buttons[0] = 0;
            this.buttons[1] = 2;
            this.buttons[2] = 3;
        }
    }

    public boolean canOverwrite(File file) {
        if (!file.exists()) {
            return true;
        }
        if (this.isYesAll()) {
            return true;
        }
        if (this.isCanceled()) {
            return false;
        }
        int result = this.buttons[this.showOverWriteDialog(file, this.shell)];
        switch (result) {
            case 0: {
                return true;
            }
            case 2: {
                return false;
            }
            case 1: {
                this.yesAll = true;
                return true;
            }
            case 3: {
                this.canceled = true;
                return false;
            }
        }
        return false;
    }

    public int showOverWriteDialog(File tmp, Shell shell) {
        String[] buttonNames = new String[]{Messages.getString("yes"), Messages.getString("yesall"), Messages.getString("no"), Messages.getString("cancel")};
        if (this.mode == 1) {
            buttonNames = new String[]{Messages.getString("yes"), Messages.getString("no"), Messages.getString("cancel")};
        }
        String fileName = tmp.getAbsolutePath();
        String fileSize = this.toFileSizeLabel(tmp.length());
        String name = tmp.getName();
        SimpleDateFormat format = new SimpleDateFormat(Messages.getString("date_format"));
        String lastModified = format.format((Object)new Date(tmp.lastModified()));
        String nameText = Messages.getString("filename");
        String dateText = Messages.getString("lastmodified");
        String sizeText = Messages.getString("filesize");
        int max = nameText.length();
        if (dateText.length() > max) {
            max = dateText.length();
        }
        if (sizeText.length() > max) {
            max = sizeText.length();
        }
        nameText = String.valueOf(nameText) + ": " + this.toSpace((max += 2) - nameText.length());
        dateText = String.valueOf(dateText) + ":" + this.toSpace(max - dateText.length());
        sizeText = String.valueOf(sizeText) + ": " + this.toSpace(max - sizeText.length());
        MessageDialog dialog = new MessageDialog(shell, Messages.getString("confirm_overwrite"), shell.getImage(), String.valueOf(Messages.getString("message_allready")) + "\n\n" + fileName + "\n\n" + nameText + name + "\n" + dateText + lastModified + "\n" + sizeText + fileSize + "\n\n" + Messages.getString("isoverwritefile") + "?", 4, buttonNames, 0);
        return dialog.open();
    }

    private String toSpace(int remain) {
        String ret = "";
        while (ret.length() < remain * 2) {
            ret = String.valueOf(ret) + " ";
        }
        return ret;
    }

    public String toFileSizeLabel(long size) {
        String result = "";
        result = size > 0x40000000L ? String.valueOf(size / 0x40000000L) + " Giga bytes" : (size > 0x100000L ? String.valueOf(size / 0x100000L) + " Mega byte" : (size > 1024L ? String.valueOf(size / 1024L) + " Kiro byte" : String.valueOf(size) + " byte"));
        return result;
    }

    public static boolean askOverwrite(FileOverwriteControler fileOverwriteControler, File file) {
        AskOverwrite overwrite = new AskOverwrite(fileOverwriteControler, file);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)overwrite);
        return overwrite.overwrite;
    }

    public static class AskOverwrite
    extends Thread {
        private FileOverwriteControler fileOverwriteControler;
        private File file;
        boolean overwrite;

        public AskOverwrite(FileOverwriteControler fileOverwriteControler, File file) {
            this.fileOverwriteControler = fileOverwriteControler;
            this.file = file;
        }

        public void run() {
            this.overwrite = this.fileOverwriteControler.canOverwrite(this.file);
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }
    }
}

