/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.greycstoration;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.util.PathnameUtils;

public class RestorationSetting {
    private int mode;
    private double alpha = 0.8;
    private double sigma = 0.5;
    private double p = 0.8;
    private double a = 0.8;
    private int dt = 50;
    private int iter = 1;
    private String exePath;
    private Process process;

    public RestorationSetting(String path) {
        this.exePath = path;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public String getExePath() {
        return this.exePath;
    }

    public void setExePath(String exePath) {
        this.exePath = exePath;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public String toFileName(String name) {
        String head = PathnameUtils.removeExtension(name);
        String exe = PathnameUtils.getExtension(name);
        String value = "_";
        value = String.valueOf(value) + "alpha(" + this.alpha + ")_";
        value = String.valueOf(value) + "sigma(" + this.sigma + ")_";
        value = String.valueOf(value) + "p(" + this.p + ")_";
        value = String.valueOf(value) + "a(" + this.a + ")_";
        value = String.valueOf(value) + "iter(" + this.iter + ")_";
        value = String.valueOf(value) + "dt(" + this.dt + ")";
        return String.valueOf(head) + value + "." + exe;
    }

    public String[] toCommand(File input, File output) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.exePath);
        list.add("-restore");
        list.add(input.getAbsolutePath());
        list.add("-alpha");
        list.add("" + this.alpha);
        list.add("-sigma");
        list.add("" + this.sigma);
        list.add("-p");
        list.add("" + this.p);
        list.add("-a");
        list.add("" + this.a);
        list.add("-iter");
        list.add("" + this.iter);
        list.add("-dt");
        list.add("" + this.dt);
        list.add("-o");
        list.add(output.getAbsolutePath());
        list.add("-visu");
        list.add("false");
        return list.toArray(new String[0]);
    }

    public int getIter() {
        return this.iter;
    }

    public void setIter(int iter) {
        this.iter = iter;
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        this.a = a;
    }

    public int getDt() {
        return this.dt;
    }

    public void setDt(int dt) {
        this.dt = dt;
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        this.p = p;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }
}

