/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.greycstoration;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedExecuter;
import jp.sourceforge.akjrcp.dropsomething.DropsomethingView;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVFileEffector;
import jp.sourceforge.akjrcp.greycstoration.RestorationSetting;
import jp.sourceforge.akjrcp.image.ImageUtil;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;

public class DirectoryBasedGreycstorationExecuter
implements DirectoryBasedExecuter {
    public static Log log;
    private DirectryBasedExecuterListener executeListener;
    private String exportDir;
    private boolean sameDirectory;
    private boolean backup;
    RestorationSetting restorationSetting;
    private Process process;
    private boolean cancelling;
    private GFFMpegFLVFileEffector effector;
    private long effectedFrame;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.greycstoration.DirectoryBasedGreycstorationExecuter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void execute(File[] files) {
        if (this.executeListener != null) {
            this.executeListener.beforeConvert();
        }
        int i = 0;
        while (i < files.length) {
            this.execute(files[i]);
            ++i;
        }
        if (this.executeListener != null) {
            this.executeListener.afterConvert();
        }
    }

    private void execute(File file) {
        if (file.isDirectory()) {
            if (this.cancelling) {
                log.info((Object)("cancel " + file));
                return;
            }
            String[] list = file.list();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    this.execute(new File(file, list[i]));
                    ++i;
                }
            }
        } else if (this.accept(file.getParentFile(), file.getName())) {
            if (this.isFLV(file)) {
                this.inExecuteMovie(file);
            } else {
                this.inExecute(file);
            }
        }
    }

    public void cancel() {
        log.info((Object)"call cancel");
        this.cancelling = true;
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.effector != null) {
            this.effector.cancel();
        }
    }

    public void setStatusValue(String value) {
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new SetMessage(value));
    }

    private void inExecuteMovie(File inputFile) {
        if (this.cancelling) {
            log.info((Object)("cancel " + inputFile));
            return;
        }
        if (this.executeListener != null) {
            this.executeListener.startConvert(inputFile);
        }
        String outputDir = inputFile.getParent();
        if (!this.sameDirectory) {
            outputDir = this.exportDir;
        }
        String outputPath = String.valueOf(outputDir) + "\\" + this.restorationSetting.toFileName(inputFile.getName());
        log.info((Object)inputFile.getAbsolutePath());
        log.info((Object)outputPath);
        File outPutFile = new File(outputPath);
        File tmpOutput = null;
        try {
            tmpOutput = File.createTempFile("grey", inputFile.getName());
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        boolean overwrite = false;
        if (outPutFile.exists() && !outPutFile.canWrite() && !outPutFile.exists() && this.executeListener != null) {
            this.executeListener.faildConvert(inputFile, "file can't overwrite");
            return;
        }
        if (!this.backup && outPutFile.exists() && this.executeListener != null && !(overwrite = this.executeListener.askOverwrite(tmpOutput))) {
            if (this.executeListener != null) {
                this.executeListener.faildConvert(inputFile, "file don't overwrite");
            }
            return;
        }
        IPreferenceStore store = Akj_betasPlugin.getDefault().getPreferenceStore();
        String ffmpegPath = store.getString("ffmpeg_path");
        this.effector = new GFFMpegFLVFileEffector(ffmpegPath, inputFile, tmpOutput);
        this.effector.setInputImageType(1);
        this.effector.setOutputImageType(1);
        this.effector.start();
        long starttime = System.currentTimeMillis();
        while (!this.effector.isDoneRead() || !this.effector.isDoneWrite()) {
            try {
                Thread.sleep(3000L);
                this.setStatusValue(String.valueOf(this.effectedFrame) + "frames done.it's about " + this.effectedFrame / 30L + "second");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("***finally finished***");
        long end = System.currentTimeMillis() - starttime;
        String min = "" + end / 1000L / 60L;
        log.info((Object)("time:" + min));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (outPutFile.exists()) {
            if (this.backup) {
                File newBackupFile = PathnameUtils.getEmptyFileName(outPutFile);
                boolean renamed = outPutFile.renameTo(newBackupFile);
                if (renamed) {
                    boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
                    if (!renamed2 && this.executeListener != null) {
                        tmpOutput.delete();
                        this.executeListener.faildConvert(inputFile, "file can't overwrite");
                        return;
                    }
                } else if (this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    return;
                }
            } else {
                outPutFile.delete();
                boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
                if (!renamed2 && this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    return;
                }
            }
        } else {
            boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
            if (!renamed2 && this.executeListener != null) {
                tmpOutput.delete();
                this.executeListener.faildConvert(inputFile, "file can't overwrite");
                return;
            }
        }
        if (this.executeListener != null) {
            this.executeListener.endConvert(inputFile);
        }
        this.effector = null;
        this.process = null;
        this.cancelling = false;
    }

    private void inExecute(File inputFile) {
        long starttime = System.currentTimeMillis();
        if (this.cancelling) {
            log.info((Object)("cancel " + inputFile));
            return;
        }
        if (this.executeListener != null) {
            this.executeListener.startConvert(inputFile);
        }
        String outputDir = inputFile.getParent();
        if (!this.sameDirectory) {
            outputDir = this.exportDir;
        }
        String outputPath = String.valueOf(outputDir) + "\\" + this.restorationSetting.toFileName(inputFile.getName());
        log.info((Object)inputFile.getAbsolutePath());
        log.info((Object)outputPath);
        File outPutFile = new File(outputPath);
        File tmpOutput = null;
        try {
            tmpOutput = File.createTempFile("grey", inputFile.getName());
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        boolean overwrite = false;
        if (outPutFile.exists() && !outPutFile.canWrite() && !outPutFile.exists() && this.executeListener != null) {
            this.executeListener.faildConvert(inputFile, "file can't overwrite");
            return;
        }
        if (!this.backup && outPutFile.exists() && this.executeListener != null && !(overwrite = this.executeListener.askOverwrite(tmpOutput))) {
            if (this.executeListener != null) {
                this.executeListener.faildConvert(inputFile, "file don't overwrite");
            }
            return;
        }
        File exeInput = null;
        File exeOutput = null;
        boolean usingTemp = false;
        if (this.isBMP(inputFile)) {
            exeInput = inputFile;
            exeOutput = tmpOutput;
        } else {
            try {
                usingTemp = true;
                exeInput = File.createTempFile("temp", ".bmp");
                Image image = new Image(null, inputFile.getAbsolutePath());
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{image.getImageData()};
                loader.save(exeInput.getAbsolutePath(), 0);
                log.trace((Object)exeInput.getAbsolutePath());
                exeOutput = File.createTempFile("temp", ".bmp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String[] commands = this.restorationSetting.toCommand(exeInput, exeOutput);
        log.info((Object)ArrayUtils.toString((Object)commands));
        Runtime runtime = Runtime.getRuntime();
        ErrorCatchProcessPrinter printer = new ErrorCatchProcessPrinter();
        try {
            printer.printOutput(DirectoryBasedGreycstorationExecuter.toDebugArray(commands));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.process = null;
        try {
            this.process = runtime.exec(commands);
            ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
            monitor.startMonitor();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.process.destroy();
            if (this.executeListener != null) {
                this.executeListener.faildConvert(inputFile, e1.getMessage());
            }
            return;
        }
        if (usingTemp) {
            try {
                BufferedImage image = ImageIO.read(exeOutput);
                if (image == null && this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    exeInput.delete();
                    exeOutput.delete();
                    return;
                }
                if (this.isJPEG(tmpOutput)) {
                    ImageUtil.writeJpegWithQuality(image, tmpOutput, 1.0f);
                } else if (this.isPNG(tmpOutput)) {
                    ImageIO.write((RenderedImage)image, "PNG", tmpOutput);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            exeInput.delete();
            exeOutput.delete();
        }
        if (outPutFile.exists()) {
            if (this.backup) {
                File newBackupFile = PathnameUtils.getEmptyFileName(outPutFile);
                boolean renamed = outPutFile.renameTo(newBackupFile);
                if (renamed) {
                    boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
                    if (!renamed2 && this.executeListener != null) {
                        tmpOutput.delete();
                        this.executeListener.faildConvert(inputFile, "file can't overwrite");
                        return;
                    }
                } else if (this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    return;
                }
            } else {
                outPutFile.delete();
                boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
                if (!renamed2 && this.executeListener != null) {
                    tmpOutput.delete();
                    this.executeListener.faildConvert(inputFile, "file can't overwrite");
                    return;
                }
            }
        } else {
            boolean renamed2 = tmpOutput.renameTo(new File(outputPath));
            if (!renamed2 && this.executeListener != null) {
                tmpOutput.delete();
                this.executeListener.faildConvert(inputFile, "file can't overwrite");
                return;
            }
        }
        long end = System.currentTimeMillis() - starttime;
        String sec = "" + end / 1000L;
        log.info((Object)("time:" + sec + "s"));
        if (this.executeListener != null) {
            this.executeListener.endConvert(inputFile);
        }
        this.process = null;
        this.cancelling = false;
    }

    public static String toDebugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public DirectryBasedExecuterListener getExecuteListener() {
        return this.executeListener;
    }

    public void setExecuteListener(DirectryBasedExecuterListener executeListener) {
        this.executeListener = executeListener;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public boolean isSameDirectory() {
        return this.sameDirectory;
    }

    public void setSameDirectory(boolean sameDirectory) {
        this.sameDirectory = sameDirectory;
    }

    public boolean accept(File parent, String name) {
        String[] supportImages = new String[]{"jpg", "bmp", "png", "flv"};
        int i = 0;
        while (i < supportImages.length) {
            if (name.toLowerCase().endsWith("." + supportImages[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isFLV(File file) {
        return file.getName().toLowerCase().endsWith(".flv");
    }

    public boolean isBMP(File file) {
        return file.getName().toLowerCase().endsWith(".bmp");
    }

    public boolean isJPEG(File file) {
        return file.getName().toLowerCase().endsWith(".jpg");
    }

    public boolean isPNG(File file) {
        return file.getName().toLowerCase().endsWith(".png");
    }

    public RestorationSetting getRestorationSetting() {
        return this.restorationSetting;
    }

    public void setRestorationSetting(RestorationSetting restorationSetting) {
        this.restorationSetting = restorationSetting;
    }

    public class SetMessage
    implements Runnable {
        String message;

        SetMessage(String message) {
            this.message = message;
        }

        public void run() {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)DropsomethingView.viewSite.getWorkbenchWindow();
            WWinActionBars actionBars = workbenchWindow.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(this.message);
        }
    }

    public class GFFMpegFLVFileEffector
    extends FFMpegFLVFileEffector {
        private ProcessPrinter printer;

        public GFFMpegFLVFileEffector(String ffmpegPath, File input, File output) {
            super(ffmpegPath, input, output);
            this.printer = new ErrorCatchProcessPrinter();
            DirectoryBasedGreycstorationExecuter.this.effectedFrame = 0L;
        }

        public void effect(File inputFile, File outputFile) {
            try {
                DirectoryBasedGreycstorationExecuter directoryBasedGreycstorationExecuter = DirectoryBasedGreycstorationExecuter.this;
                directoryBasedGreycstorationExecuter.effectedFrame = directoryBasedGreycstorationExecuter.effectedFrame + 1L;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            String[] commands = DirectoryBasedGreycstorationExecuter.this.restorationSetting.toCommand(inputFile, outputFile);
            Runtime runtime = Runtime.getRuntime();
            DirectoryBasedGreycstorationExecuter.this.process = null;
            try {
                DirectoryBasedGreycstorationExecuter.this.process = runtime.exec(commands);
                ProcessMonitor monitor = new ProcessMonitor(DirectoryBasedGreycstorationExecuter.this.process, this.printer);
                monitor.startMonitor();
                try {
                    DirectoryBasedGreycstorationExecuter.this.process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                DirectoryBasedGreycstorationExecuter directoryBasedGreycstorationExecuter = DirectoryBasedGreycstorationExecuter.this;
                directoryBasedGreycstorationExecuter.effectedFrame = directoryBasedGreycstorationExecuter.effectedFrame + 1L;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                DirectoryBasedGreycstorationExecuter.this.process.destroy();
                if (DirectoryBasedGreycstorationExecuter.this.executeListener != null) {
                    DirectoryBasedGreycstorationExecuter.this.executeListener.faildConvert(inputFile, e1.getMessage());
                }
                return;
            }
        }
    }

    public class ErrorCatchProcessPrinter
    implements ProcessPrinter {
        public void printOutput(String output) throws IOException {
            this.print(output);
        }

        public void printError(String error) throws IOException {
            this.print(error);
        }

        private void print(String line) throws IOException {
            if (DirectoryBasedGreycstorationExecuter.this.executeListener != null) {
                DirectoryBasedGreycstorationExecuter.this.executeListener.printProcess(line);
            }
            log.debug((Object)line);
        }
    }
}

