/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.search;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.flvtools.search.FirefoxUtil;
import jp.sourceforge.akjrcp.flvtools.search.YoutubeSearchKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SearchView
extends ViewPart {
    public static final String SEARCH_KEYS = "search_view.search_keys";
    public static Log log;
    public static final String ID;
    private TableViewer viewer;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;
    private ArrayList keyList = new ArrayList();
    private Button addButton;
    private Button searchButton;
    private Text inputText;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.search.SearchView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.search.SearchView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz2.getName();
    }

    private void remove(List objects) {
        this.keyList.removeAll(objects);
        objects.toArray(new YoutubeSearchKey[0]);
        this.viewer.refresh();
        this.updateKeywordData();
    }

    private void updateKeywordData() {
        Akj_betasPlugin.getDefault().getPluginPreferences().setValue(SEARCH_KEYS, this.getSearchKeysFormat());
    }

    private String getSearchKeysFormat() {
        String value = "";
        YoutubeSearchKey[] keys = this.keyList.toArray(new YoutubeSearchKey[0]);
        int i = 0;
        while (i < keys.length) {
            value = String.valueOf(value) + keys[i].toFormat() + "\n";
            ++i;
        }
        return value;
    }

    private void setSearchKeysFormat() {
        this.keyList.removeAll(this.keyList);
        String vs = Akj_betasPlugin.getDefault().getPluginPreferences().getString(SEARCH_KEYS);
        log.debug((Object)("value=" + vs));
        if (vs.equals("")) {
            return;
        }
        String[] formats = vs.split("\n");
        int i = 0;
        while (i < formats.length) {
            YoutubeSearchKey key = new YoutubeSearchKey();
            log.info((Object)formats[i]);
            key.setFormat(formats[i]);
            this.keyList.add(key);
            ++i;
        }
    }

    public void addText() {
        String text = this.inputText.getText();
        if (text.length() > 0) {
            this.keyList.add(new YoutubeSearchKey(text, null));
            this.viewer.refresh();
            this.updateKeywordData();
            this.inputText.setText("");
        }
    }

    public void createPartControl(Composite parent) {
        Akj_betasPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new SettingMonitor());
        this.setSearchKeysFormat();
        GridLayout gridLayout = new GridLayout(2, false);
        parent.setLayout((Layout)gridLayout);
        this.inputText = new Text(parent, 4);
        GridData layout1 = new GridData(768);
        layout1.horizontalSpan = 2;
        this.inputText.setLayoutData((Object)layout1);
        this.inputText.addSelectionListener((SelectionListener)new TextSubmitListener());
        this.searchButton = new Button(parent, 0);
        this.searchButton.setText(Messages.getString("search"));
        this.searchButton.setToolTipText(Messages.getString("search_tooltip"));
        this.searchButton.addSelectionListener((SelectionListener)new SearchAction());
        this.addButton = new Button(parent, 0);
        this.addButton.setText(Messages.getString("add"));
        this.addButton.setToolTipText(Messages.getString("add_tooltip"));
        this.addButton.addSelectionListener((SelectionListener)new TextSubmitListener());
        this.viewer = new TableViewer(parent, 770);
        this.viewer.getTable().setToolTipText(Messages.getString("searchtable_tooltip"));
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        GridData layout4 = new GridData(1808);
        layout4.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)layout4);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SearchView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                this.removeSelection();
            }

            private void removeSelection() {
                SearchView.this.remove(((IStructuredSelection)SearchView.this.viewer.getSelection()).toList());
            }
        };
        this.action1.setText(Messages.getString("remove_selections"));
        this.action1.setToolTipText(Messages.getString("remove_selections"));
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                SearchView.this.showMessage("Action 2 executed");
            }
        };
        this.action2.setText("Action 2");
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = SearchView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).toArray()[0];
                log.debug((Object)obj.getClass().getName());
                String word = "";
                Object[] objs = ((IStructuredSelection)selection).toArray();
                int i = 0;
                while (i < objs.length) {
                    if (objs[i] instanceof YoutubeSearchKey) {
                        word = String.valueOf(word) + ((YoutubeSearchKey)objs[i]).getKeyword();
                        if (i != objs.length - 1) {
                            word = String.valueOf(word) + " ";
                        }
                    }
                    ++i;
                }
                SearchView.this.search(word);
                SearchView.this.viewer.refresh();
            }
        };
    }

    public void search(String keys) {
        log.debug((Object)("key=" + keys));
        try {
            String encoded = URLEncoder.encode(keys, "UTF-8");
            log.debug((Object)("encoded=" + encoded));
            String baseURL = "http://www.youtube.com/results?search_query=" + encoded;
            String sort = Akj_betasPlugin.getDefault().getPluginPreferences().getString("search.search_mode");
            if (!sort.equals("relevance")) {
                baseURL = String.valueOf(baseURL) + "&search_sort=" + sort;
            }
            this.openURL(baseURL);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public boolean useFirefox() {
        return Akj_betasPlugin.getDefault().getPluginPreferences().getBoolean("search.use_firefox") && FirefoxUtil.isAvailable();
    }

    public void openURL(String url) {
        if (this.useFirefox()) {
            FirefoxUtil.openURL(url);
        } else {
            Program program = Program.findProgram((String)".html");
            if (program != null) {
                log.debug((Object)program.getName());
                program.execute(url);
            }
        }
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SearchView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Sample View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            log.debug((Object)(oldInput + "," + newInput));
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return SearchView.this.keyList.toArray(new YoutubeSearchKey[0]);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            if (SearchView.this.useFirefox()) {
                return FirefoxUtil.getFirefoxImage();
            }
            Program program = Program.findProgram((String)".html");
            log.info((Object)program.getName());
            ImageData data = program.getImageData();
            if (data == null) {
                return FirefoxUtil.getOtherImage();
            }
            return new Image((Device)PlatformUI.getWorkbench().getDisplay(), program.getImageData());
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    public class TextSubmitListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SearchView.this.addText();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            SearchView.this.addText();
        }
    }

    public class SearchAction
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            String v = SearchView.this.inputText.getText();
            SearchView.this.search(v);
            SearchView.this.viewer.refresh();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class SettingMonitor
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            log.info((Object)event.getProperty());
            if (event.getProperty().equals("search.use_firefox")) {
                SearchView.this.viewer.refresh();
            }
        }
    }
}

