/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.FilePlayer;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.flvtools.basic.FLVUtil;
import jp.sourceforge.akjrcp.flvtools.basic.OpenDirectable;
import jp.sourceforge.akjrcp.flvtools.basic.SimpleView;
import jp.sourceforge.akjrcp.flvtools.explorer.ConvertingMonitorDialog;
import jp.sourceforge.akjrcp.flvtools.explorer.FFMpegExecutable;
import jp.sourceforge.akjrcp.flvtools.explorer.FFMpegExecuter;
import jp.sourceforge.akjrcp.flvtools.explorer.FlowPlayerShell;
import jp.sourceforge.akjrcp.flvtools.explorer.MonitorCancelable;
import jp.sourceforge.akjrcp.flvtools.explorer.RenameDialog;
import jp.sourceforge.akjrcp.flvtools.explorer.ThumbnailManager;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class ExplorerView
extends ViewPart
implements OpenDirectable,
FFMpegExecutable,
MonitorCancelable {
    public static Log log;
    public static final String ID;
    private String currentDir;
    private String[] assistantNames;
    private Text directoryPath;
    protected static Image noImage;
    protected static Image loadingImage;
    protected static Image moveUpImage;
    protected static Image folderImage;
    private File currentFile = null;
    private boolean firstPaint = true;
    ConvertingMonitorDialog convertingDialog;
    private FFMpegExecuter ffmpegExecuter;
    ExplorerView self;
    Menu canvasPopup;
    private String[] folders;
    ArrayList actionValueList = new ArrayList();
    private FigureCanvas canvas;
    private Figure rootFigure;
    private FlowPlayerShell flowPlayerShell;
    private MenuItem convert;
    private int executingIndex;
    private Explorer explorerFigure;
    private MenuItem enableseek;
    private MenuItem renameFile;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz2.getName();
        Display display = Display.getCurrent();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        noImage = new Image((Device)display, clazz3.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/noimage.png"));
        Display display2 = Display.getCurrent();
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        loadingImage = new Image((Device)display2, clazz4.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/loading.png"));
        Display display3 = Display.getCurrent();
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        moveUpImage = new Image((Device)display3, clazz5.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/moveup.png"));
        Display display4 = Display.getCurrent();
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        folderImage = new Image((Device)display4, clazz6.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/folder_large.png"));
    }

    public void initAssistantName(File file) {
        String[] list = file.list();
        FLVFilter filter = new FLVFilter();
        ArrayList<String> tmpNames = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            File tmp = new File(file, list[i]);
            if (tmp.isDirectory()) {
                String[] flvList = tmp.list(filter);
                int j = 0;
                while (j < flvList.length) {
                    String flvKey = this.trimNumberName(flvList[j].substring(0, flvList[j].length() - ".flv".length()));
                    tmpNames.remove(flvKey);
                    tmpNames.add(flvKey);
                    ++j;
                }
            }
            ++i;
        }
        this.assistantNames = tmpNames.toArray(new String[0]);
    }

    private String trimNumberName(String name) {
        int x;
        String newName = name;
        if (name.endsWith(")") && (x = name.lastIndexOf("(")) != -1) {
            String digi = name.substring(x + 1, name.length() - 1);
            boolean isDigit = true;
            int i = 0;
            while (i < digi.length()) {
                if (!Character.isDigit(digi.charAt(i))) {
                    isDigit = false;
                    break;
                }
                ++i;
            }
            if (isDigit) {
                newName = name.substring(0, x);
            }
        }
        return newName;
    }

    public void ffmpegEnableChanged(boolean bool) {
        this.convert.setEnabled(bool);
    }

    public static File getEmptyFileName(File file) {
        String fileName;
        if (!file.exists()) {
            return file;
        }
        String head = fileName = file.getName();
        int e = fileName.lastIndexOf(".");
        String ext = "";
        if (e != -1) {
            ext = fileName.substring(e);
            head = fileName.substring(0, e);
        }
        int index = 1;
        File newFile = null;
        while (newFile == null || newFile.exists()) {
            String newName = String.valueOf(head) + "(" + index + ")" + ext;
            newFile = new File(file.getParentFile(), newName);
            ++index;
        }
        return newFile;
    }

    public ExplorerView() {
        this.self = this;
    }

    public String findBaseDir() {
        String baseDir = SimpleView.findBaseDir();
        return baseDir;
    }

    public void createPartControl(Composite root) {
        ThumbnailManager.clearThumbnails();
        root.setLayout((Layout)new GridLayout(1, false));
        Composite controler = new Composite(root, 0);
        controler.setLayoutData((Object)new GridData(768));
        controler.setLayout((Layout)new GridLayout(2, false));
        Button reloadButton = new Button(controler, 0);
        reloadButton.setText(Messages.getString("reload"));
        reloadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.reload();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.directoryPath = new Text(controler, 12);
        GridData datax = new GridData(768);
        this.directoryPath.setLayoutData((Object)datax);
        this.canvas = new FigureCanvas(root);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.rootFigure = new Figure();
        this.canvas.setContents((IFigure)this.rootFigure);
        this.rootFigure.setLayoutManager((LayoutManager)new StackLayout());
        this.canvas.addControlListener((ControlListener)new ResizeMonitor(this.rootFigure));
        this.canvasPopup = new Menu((Control)this.canvas);
        this.canvas.setMenu(this.canvasPopup);
        MenuItem player = new MenuItem(this.canvasPopup, 64);
        player.setText(Messages.getString("explorer.play"));
        Menu playMenu = new Menu(player);
        player.setMenu(playMenu);
        MenuItem systemPlayItem = new MenuItem(playMenu, 8);
        systemPlayItem.setText(Messages.getString("explorer.System-Player"));
        systemPlayItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FilePlayer.play(ExplorerView.this.currentFile, "flv");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem flowPlayItem = new MenuItem(playMenu, 8);
        flowPlayItem.setText(Messages.getString("explorer.flowPlayer"));
        flowPlayItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.playFlowPlayer(ExplorerView.this.currentFile);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableseek = new MenuItem(this.canvasPopup, 8);
        this.enableseek.setText(Messages.getString("enable_seek"));
        this.enableseek.setEnabled(this.isEnableFLVTool2());
        this.enableseek.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.callFLVTool2();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.renameFile = new MenuItem(this.canvasPopup, 8);
        this.renameFile.setText(Messages.getString("explorer.rename_file"));
        this.renameFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.renameFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        root.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ExplorerView.this.firstPaint) {
                    ExplorerView.this.firstPaint = false;
                    ExplorerView.this.openDirectory(ExplorerView.this.findBaseDir());
                }
            }
        });
    }

    public void reload() {
        this.openDirectory(this.currentDir);
        this.canvas.forceFocus();
    }

    public void renameFile() {
        RenameDialog dialog = new RenameDialog((IWorkbenchSite)this.self.getSite());
        dialog.setFiles(this.toSelectionFiles());
        dialog.open();
        int returncode = dialog.getReturnCode();
        if (returncode == 0) {
            this.reload();
        }
    }

    private File[] toSelectionFiles() {
        ThumbnailFigure[] figures = this.explorerFigure.getSelectionThumbnails();
        File[] file = new File[figures.length];
        int i = 0;
        while (i < file.length) {
            file[i] = figures[i].toFile();
            ++i;
        }
        return file;
    }

    private boolean isEnableFLVTool2() {
        File exe;
        String path = Akj_betasPlugin.getDefault().getPreferenceStore().getString("flvtool2_path");
        return path.endsWith("flvtool2.exe") && (exe = new File(path)).exists();
    }

    public void callFLVTool2() {
        File file;
        Runtime runtime = Runtime.getRuntime();
        String path = Akj_betasPlugin.getDefault().getPreferenceStore().getString("flvtool2_path");
        if (path.endsWith("flvtool2.exe") && (file = new File(path)).exists()) {
            String[] args = path.indexOf("akj_friends") != -1 ? new String[]{path, "-U", this.currentFile.getAbsolutePath()} : new String[]{path, "u", this.currentFile.getAbsolutePath()};
            try {
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IProgressMonitor convertMonitor = workbenchWindow.getStatusLineManager().getProgressMonitor();
                Process p = runtime.exec(args);
                try {
                    p.waitFor();
                    convertMonitor.done();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void playFile(File file) {
        log.info((Object)("playFile:" + file));
        boolean primaryFlowPlayer = Akj_betasPlugin.getDefault().getPreferenceStore().getBoolean("primary_flowplayer");
        if (primaryFlowPlayer) {
            this.playFlowPlayer(file);
        } else if (!FilePlayer.play(file)) {
            this.playFlowPlayer(file);
        }
    }

    public void playFlowPlayer(File file) {
        if (this.isFLVExtension(file)) {
            if (this.flowPlayerShell == null || this.flowPlayerShell.getShell().isDisposed()) {
                this.flowPlayerShell = new FlowPlayerShell(this.getSite().getShell());
            }
            this.flowPlayerShell.openFLVFile(file);
        }
    }

    public boolean isFLVExtension(File file) {
        return file.getName().toLowerCase().endsWith(".flv");
    }

    public void showConvertingStatus() {
        this.convertingDialog = new ConvertingMonitorDialog((IWorkbenchSite)this.self.getSite());
        this.convertingDialog.setCancelable(this);
        if (this.ffmpegExecuter != null) {
            log.info((Object)("" + this.executingIndex));
            this.convertingDialog.setFileList(this.ffmpegExecuter.getFileList());
            this.convertingDialog.selectFile(this.executingIndex);
        }
        this.convertingDialog.open();
    }

    public void openDirectory(String path) {
        log.info((Object)("path:" + path));
        this.directoryPath.setText(path);
        this.currentDir = path;
        File file = new File(path);
        this.initAssistantName(file);
        this.initFolder(file);
        this.initList(file);
        this.updatePopupMenu(file);
        String flvaddmode = Akj_betasPlugin.getDefault().getPreferenceStore().getString("explorer.addextension");
        if (!this.isEveryFLVOK(file) && !flvaddmode.equals("add_never")) {
            int dialog_button = 0;
            if (flvaddmode.equals("add_dialog")) {
                MessageDialog dialog = new MessageDialog(this.getSite().getShell(), Messages.getString("confirm_rename"), null, Messages.getString("confirm_rename_message"), 2, new String[]{"OK", "Cancell"}, 0);
                dialog_button = dialog.open();
            }
            log.info((Object)("dialog:" + dialog_button));
            if (dialog_button == 0) {
                String[] flvs = this.getFLVFiles(file);
                int i = 0;
                while (i < flvs.length) {
                    if (!flvs[i].toLowerCase().endsWith(".flv")) {
                        File flv = new File(flvs[i]);
                        File newFile = new File(FileNameUtils.getChangedExtensionName(flv, "flv"));
                        boolean result = flv.renameTo(newFile);
                        log.info((Object)("result:" + result + " " + newFile));
                    }
                    ++i;
                }
                this.initList(file);
            }
        }
    }

    public void updatePopupMenu(File file) {
    }

    public boolean isEveryFLVOK(File file) {
        String[] files = this.getFLVFiles(file);
        int i = 0;
        while (i < files.length) {
            if (!files[i].toLowerCase().endsWith(".flv")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getFLVFiles(File baseDir) {
        String[] list = baseDir.list();
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            File file2 = new File(baseDir, list[i]);
            if (FLVUtil.isFLV(file2)) {
                array.add(file2.getAbsolutePath());
            }
            ++i;
        }
        return array.toArray(new String[0]);
    }

    public void initList(File file) {
        this.actionValueList.removeAll(this.actionValueList);
        this.rootFigure.removeAll();
        String[] flvfiles = this.getFLVFiles(file);
        this.explorerFigure = new Explorer();
        this.explorerFigure.setBackgroundColor(ColorConstants.white);
        this.explorerFigure.add((IFigure)new MoveUpFigure("", moveUpImage));
        this.explorerFigure.setLayoutManager(new CustomLayout(this.rootFigure));
        ImageLoader imageLoader = new ImageLoader();
        int i = 0;
        while (i < flvfiles.length) {
            File f = new File(flvfiles[i]);
            String name = this.trimExtension(f.getName());
            ThumbnailFigure th = new ThumbnailFigure(name, loadingImage);
            if (!f.getName().toLowerCase().endsWith(".flv")) {
                log.info((Object)"no extension");
                th.setHasExtension(false);
            }
            this.explorerFigure.add((IFigure)th);
            imageLoader.add(th, f);
            ++i;
        }
        String[] list = file.list();
        int i2 = 0;
        while (i2 < list.length) {
            if (new File(file, list[i2]).isDirectory()) {
                this.explorerFigure.add((IFigure)new FolderFigure(list[i2], folderImage));
            }
            ++i2;
        }
        this.rootFigure.add((IFigure)this.explorerFigure);
        Thread t = new Thread(imageLoader);
        t.start();
    }

    private String trimExtension(String name) {
        int e = name.toLowerCase().lastIndexOf(".flv");
        if (e != -1) {
            return name.substring(0, e);
        }
        return name;
    }

    private void initFolder(File file) {
        String[] list = file.list();
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            if (new File(file, list[i]).isDirectory()) {
                array.add(list[i]);
            }
            ++i;
        }
        this.folders = array.toArray(new String[0]);
    }

    private CCombo makeComboBox(Composite panel) {
        CCombo box = new CCombo(panel, 8);
        box.add("");
        int i = 0;
        while (i < this.folders.length) {
            box.add(this.folders[i]);
            ++i;
        }
        return box;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExplorerView.this.fillContextMenu(manager);
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    public void openDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        String path = dialog.open();
        if (path != null) {
            this.openDirectory(path);
        }
    }

    public void setFocus() {
        this.canvas.forceFocus();
    }

    public void startExecute(File[] files) {
        this.getProgressMonitor().beginTask(Messages.getString("converting"), files.length);
        this.convert.setEnabled(false);
        this.enableseek.setEnabled(false);
        this.renameFile.setEnabled(false);
    }

    public void finishExecute() {
        this.ffmpegExecuter = null;
        this.convert.setEnabled(true);
        this.enableseek.setEnabled(true);
        this.renameFile.setEnabled(true);
    }

    public void executingFile(File file, int index) {
        log.info((Object)("executingFile:" + index));
        this.executingIndex = index;
        if (this.convertingDialog != null && this.convertingDialog.isOpened()) {
            log.info((Object)("update:" + this.executingIndex));
            this.convertingDialog.updateSelect(this.executingIndex);
        }
    }

    public IProgressMonitor getProgressMonitor() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return workbenchWindow.getStatusLineManager().getProgressMonitor();
    }

    public void cancel() {
        if (this.ffmpegExecuter != null) {
            this.ffmpegExecuter.cancel();
        }
    }

    static /* synthetic */ void access$1(ExplorerView explorerView, File file) {
        explorerView.currentFile = file;
    }

    static /* synthetic */ MenuItem access$3(ExplorerView explorerView) {
        return explorerView.enableseek;
    }

    static /* synthetic */ boolean access$4(ExplorerView explorerView) {
        return explorerView.isEnableFLVTool2();
    }

    public class ImageLoader
    implements Runnable {
        ArrayList list = new ArrayList();

        public void run() {
            Object[] figure_file = this.list.toArray();
            int i = 0;
            while (i < figure_file.length) {
                Object[] th_file = (Object[])figure_file[i];
                ThumbnailFigure figure = (ThumbnailFigure)((Object)th_file[0]);
                Image img = ThumbnailManager.loadThumbnail((File)th_file[1], noImage);
                if (ExplorerView.this.getSite().getShell().getDisplay() != null) {
                    ExplorerView.this.getSite().getShell().getDisplay().asyncExec((Runnable)new SetImage(img, figure));
                } else {
                    log.warn((Object)"display null");
                }
                ++i;
            }
        }

        public void add(ThumbnailFigure figure, File file) {
            this.list.add(new Object[]{figure, file});
        }
    }

    public class SetImage
    implements Runnable {
        Image img;
        ThumbnailFigure figure;

        public SetImage(Image img, ThumbnailFigure figure) {
            this.img = img;
            this.figure = figure;
        }

        public void run() {
            this.figure.setImage(this.img);
        }
    }

    public class FLVFilter
    implements FilenameFilter {
        public boolean accept(File arg0, String arg1) {
            return arg1.toLowerCase().endsWith(".flv");
        }
    }

    public class MoveAction
    extends Thread {
        public void run() {
            ActionValues[] values = ExplorerView.this.actionValueList.toArray(new ActionValues[0]);
            int i = 0;
            while (i < values.length) {
                values[i].setEnabled(false);
                ++i;
            }
            i = 0;
            while (i < values.length) {
                this.execMove(values[i]);
                ++i;
            }
            ExplorerView.this.openDirectory(ExplorerView.this.currentDir);
        }

        private void execMove(ActionValues values) {
            File parent = values.getFile().getParentFile();
            String path = parent.getAbsolutePath();
            String dir = values.getNewDirectory();
            if (dir.length() > 0) {
                path = String.valueOf(path) + "\\" + dir;
            }
            path = String.valueOf(path) + "\\" + this.trim(values.getNewName());
            path = String.valueOf(path) + ".flv";
            if (!values.getFile().getAbsolutePath().equals(path)) {
                log.info((Object)("rename to:" + path));
                File renameFile = new File(path);
                File emptyName = ExplorerView.getEmptyFileName(renameFile);
                boolean result = values.getFile().renameTo(emptyName);
                if (!result) {
                    log.warn((Object)("rename faild:" + emptyName.getAbsolutePath()));
                }
            }
        }

        private String trim(String name) {
            if (name.toLowerCase().endsWith(".flv")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
    }

    public class SettingMonitor
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            log.info((Object)event.getProperty());
            if (!event.getProperty().equals("monitor_dir") && event.getProperty().equals("ffmpeg_path")) {
                ExplorerView.this.ffmpegEnableChanged(Akj_betasPlugin.getDefault().isFFMpegAvailable());
            }
        }
    }

    public class ExecExecuter
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new MoveAction());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class DoneProgressMonitor
    implements Runnable {
        IProgressMonitor monitor;

        public DoneProgressMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void run() {
            this.monitor.done();
        }
    }

    public class SetProgressMonitor
    implements Runnable {
        IProgressMonitor monitor;
        String text;
        int step;

        public SetProgressMonitor(IProgressMonitor monitor, String text, int step) {
            this.monitor = monitor;
            this.text = text;
            this.step = step;
        }

        public void run() {
            this.monitor.beginTask(this.text, this.step);
        }
    }

    public class MoveUpFigure
    extends Panel {
        Label titleLabel;
        Label imageLabel;

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public MoveUpFigure(String label, Image img) {
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new Label(img);
            this.imageLabel.setToolTip((IFigure)new Label(label));
            this.add((IFigure)this.imageLabel);
            this.titleLabel = new Label(label);
            this.add((IFigure)this.titleLabel);
            this.imageLabel.setToolTip((IFigure)new Label(Messages.getString("moveup_directory")));
            this.setBorder((Border)new MarginBorder(2));
            this.addMouseListener(new MouseListener(this){
                final /* synthetic */ MoveUpFigure this$1;
                {
                    this.this$1 = moveUpFigure;
                }

                public void mousePressed(MouseEvent arg0) {
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseDoubleClicked(MouseEvent arg0) {
                    String path = new File(ExplorerView.access$0(MoveUpFigure.access$0(this.this$1))).getParent();
                    log.info((Object)path);
                    MoveUpFigure.access$0(this.this$1).openDirectory(path);
                }
            });
        }

        static /* synthetic */ ExplorerView access$0(MoveUpFigure moveUpFigure) {
            return moveUpFigure.ExplorerView.this;
        }
    }

    public class FolderFigure
    extends Panel {
        private String realName;
        Label titleLabel;
        Label imageLabel;

        public void setSelection(boolean bool) {
        }

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public FolderFigure(String label, Image img) {
            this.realName = label;
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new Label(img);
            this.imageLabel.setToolTip((IFigure)new Label(label));
            this.add((IFigure)this.imageLabel);
            this.titleLabel = new Label(this.trimTitle(label));
            this.add((IFigure)this.titleLabel);
            this.setBorder((Border)new MarginBorder(2));
            this.addMouseListener(new MouseListener(this){
                final /* synthetic */ FolderFigure this$1;
                {
                    this.this$1 = folderFigure;
                }

                public void mousePressed(MouseEvent arg0) {
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseDoubleClicked(MouseEvent arg0) {
                    File dir = new File(ExplorerView.access$0(FolderFigure.access$1(this.this$1)), FolderFigure.access$0(this.this$1));
                    FolderFigure.access$1(this.this$1).openDirectory(dir.getAbsolutePath());
                }
            });
        }

        public String trimTitle(String name) {
            return name.substring(0, Math.min(16, name.length()));
        }

        static /* synthetic */ String access$0(FolderFigure folderFigure) {
            return folderFigure.realName;
        }

        static /* synthetic */ ExplorerView access$1(FolderFigure folderFigure) {
            return folderFigure.ExplorerView.this;
        }
    }

    public class Explorer
    extends Panel {
        public ThumbnailFigure[] getSelectionThumbnails() {
            ArrayList<Figure> list = new ArrayList<Figure>();
            Figure[] figures = this.getChildren().toArray(new Figure[0]);
            int i = 0;
            while (i < figures.length) {
                if (figures[i] instanceof ThumbnailFigure && ((ThumbnailFigure)figures[i]).isSelection()) {
                    list.add(figures[i]);
                }
                ++i;
            }
            return list.toArray(new ThumbnailFigure[0]);
        }
    }

    public class ThumbnailFigure
    extends Panel {
        Label titleLabel;
        Label imageLabel;
        boolean hasExtension = true;
        boolean selection;
        LineBorder lineBorder;
        MarginBorder marginBorder;
        private String realName;

        public String trimTitle(String name) {
            return name.substring(0, Math.min(16, name.length()));
        }

        public void setSelection(boolean bool) {
            if (this.selection != bool) {
                this.selection = bool;
                if (this.selection) {
                    this.setBorder((Border)this.lineBorder);
                } else {
                    this.setBorder((Border)this.marginBorder);
                }
                this.repaint();
            }
        }

        public boolean isSelection() {
            return this.selection;
        }

        public void turnSelection() {
            this.setSelection(!this.selection);
        }

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public File toFile() {
            if (this.isHasExtension()) {
                return new File(ExplorerView.this.currentDir, String.valueOf(this.realName) + ".flv");
            }
            return new File(ExplorerView.this.currentDir, this.realName);
        }

        public ThumbnailFigure(String label, Image img) {
            this.realName = label;
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new Label(img);
            this.imageLabel.setToolTip((IFigure)new Label(label));
            this.add((IFigure)this.imageLabel);
            this.titleLabel = new Label(this.trimTitle(label));
            this.add((IFigure)this.titleLabel);
            this.addMouseListener(new MouseListener(this){
                final /* synthetic */ ThumbnailFigure this$1;
                {
                    this.this$1 = thumbnailFigure;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    ExplorerView.access$1(ThumbnailFigure.access$0(this.this$1), this.this$1.toFile());
                    log.trace((Object)("currentFile:" + ExplorerView.access$2(ThumbnailFigure.access$0(this.this$1))));
                    ExplorerView.access$3(ThumbnailFigure.access$0(this.this$1)).setEnabled(ExplorerView.access$4(ThumbnailFigure.access$0(this.this$1)));
                    if (mouseEvent.button == 1) {
                        if ((mouseEvent.getState() & 0x40000) > 0) {
                            this.this$1.turnSelection();
                        } else {
                            this.this$1.unselectAll();
                            this.this$1.turnSelection();
                        }
                    } else if (mouseEvent.button == 3) {
                        this.this$1.setSelection(true);
                    }
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseDoubleClicked(MouseEvent arg0) {
                    ThumbnailFigure.access$0(this.this$1).playFile(this.this$1.toFile());
                }
            });
            this.lineBorder = new LineBorder();
            this.lineBorder.setColor(ColorConstants.green);
            this.lineBorder.setWidth(2);
            this.marginBorder = new MarginBorder(2);
            this.setBorder((Border)this.marginBorder);
        }

        public void unselectAll() {
            Figure[] figures = this.getParent().getChildren().toArray(new Figure[0]);
            int i = 0;
            while (i < figures.length) {
                if (figures[i] instanceof ThumbnailFigure && figures[i] != this) {
                    ((ThumbnailFigure)figures[i]).setSelection(false);
                }
                ++i;
            }
        }

        public void selectAll() {
            Figure[] figures = this.getParent().getChildren().toArray(new Figure[0]);
            int i = 0;
            while (i < figures.length) {
                if (figures[i] instanceof ThumbnailFigure) {
                    ((ThumbnailFigure)figures[i]).setSelection(true);
                }
                ++i;
            }
        }

        public boolean isHasExtension() {
            return this.hasExtension;
        }

        public void setHasExtension(boolean hasExtension) {
            this.hasExtension = hasExtension;
        }

        static /* synthetic */ ExplorerView access$0(ThumbnailFigure thumbnailFigure) {
            return thumbnailFigure.ExplorerView.this;
        }
    }

    public class CustomLayout
    implements LayoutManager {
        Figure control;

        public CustomLayout(Figure control) {
            this.control = control;
        }

        public Object getConstraint(IFigure child) {
            return null;
        }

        public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
            return this.getPreferredSize(container, wHint, hHint);
        }

        public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
            this.layout(container);
            Figure[] figures = container.getChildren().toArray(new Figure[0]);
            int my = 0;
            int i = 0;
            while (i < figures.length) {
                my = Math.max(my, figures[i].getLocation().y + figures[i].getSize().height);
                ++i;
            }
            return new Dimension(this.control.getClientArea().x, my);
        }

        public void invalidate() {
        }

        public void layout(IFigure container) {
            Figure[] figures = container.getChildren().toArray(new Figure[0]);
            int space = 1;
            int dx = 0;
            int dy = 0;
            int preHeight = 0;
            if (this.control.getSize().width == 0 && this.control.getSize().height == 0) {
                return;
            }
            int i = 0;
            while (i < figures.length) {
                Dimension d = figures[i].getPreferredSize();
                if (dx == 0) {
                    figures[i].setLocation(new Point(dx, dy));
                    figures[i].setSize(d.width, d.height);
                    dx += d.width + space;
                    preHeight = d.height + space;
                } else {
                    int sc = 0;
                    if (!ExplorerView.this.canvas.getVerticalBar().isEnabled()) {
                        sc = 16;
                    }
                    if (dx + d.width > this.control.getClientArea().width - sc) {
                        dx = 0;
                        dy += preHeight;
                    }
                    figures[i].setLocation(new Point(dx, dy));
                    figures[i].setSize(d.width, d.height);
                    dx += d.width + space;
                    preHeight = d.height + space;
                }
                ++i;
            }
            int my = 0;
            int i2 = 0;
            while (i2 < figures.length) {
                my = Math.max(my, figures[i2].getLocation().y + figures[i2].getSize().height);
                ++i2;
            }
        }

        public void remove(IFigure child) {
        }

        public void setConstraint(IFigure child, Object constraint) {
        }
    }

    public class ResizeMonitor
    implements ControlListener {
        Figure figure;

        public ResizeMonitor(Figure figure) {
            this.figure = figure;
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            this.figure.revalidate();
        }
    }

    public class ActionValues
    implements org.eclipse.swt.events.MouseListener {
        private File file;
        private CCombo combo;
        private CCombo text;

        public File getFile() {
            return this.file;
        }

        public String getNewName() {
            return this.text.getText();
        }

        public String getNewDirectory() {
            return this.combo.getText();
        }

        public void setEnabled(boolean bool) {
            this.combo.setEnabled(bool);
            this.text.setEnabled(bool);
        }

        public ActionValues(File file, CCombo combo, CCombo text) {
            this.file = file;
            this.combo = combo;
            this.text = text;
        }

        public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            log.warn((Object)"mouse");
        }

        public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
        }

        public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
        }
    }
}

