/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFMpegExecuter {
    public static Log log;
    private boolean useAvisynth;
    private String[] ignoreAvisynthExtensions = new String[]{"mp3", "flv"};
    private DirectryBasedExecuterListener executeListener;
    private String exportDir;
    private boolean sameDirectory;
    private boolean backup;
    private FFMpegPreference ffmpegPreference = new FFMpegPreference();
    private Process process;
    private boolean cancelling;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void execute(File[] files) {
        if (this.executeListener != null) {
            this.executeListener.beforeConvert();
        }
        int i = 0;
        while (i < files.length) {
            this.execute(files[i]);
            ++i;
        }
        if (this.executeListener != null) {
            this.executeListener.afterConvert();
        }
    }

    private void execute(File file) {
        if (file.isDirectory()) {
            if (this.cancelling) {
                log.info((Object)("cancel " + file));
                return;
            }
            String[] list = file.list();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    this.execute(new File(file, list[i]));
                    ++i;
                }
            }
        } else {
            this.inExecute(file);
        }
    }

    public void cancel() {
        log.info((Object)"call cancel");
        this.cancelling = true;
        if (this.process != null) {
            this.process.destroy();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void inExecute(File file) {
        block34: {
            if (this.cancelling) {
                log.info((Object)("cancel " + file));
                return;
            }
            if (this.executeListener != null) {
                this.executeListener.startConvert(file);
            }
            String outputDir = file.getParent();
            if (!this.sameDirectory) {
                outputDir = this.exportDir;
            }
            String remain = PathnameUtils.getRemainPath(file.getParent(), PathnameUtils.changeExtension(file.getAbsolutePath(), this.ffmpegPreference.getExtension()));
            String outputPath = PathnameUtils.createPath(String.valueOf(outputDir) + "\\", remain);
            if (file.getAbsolutePath().equals(outputPath) && this.executeListener != null) {
                this.executeListener.faildConvert(file, "input and output is same");
                return;
            }
            boolean overwrite = false;
            File tmpOutput = new File(outputPath);
            if (tmpOutput.exists() && !tmpOutput.canWrite() && this.executeListener != null) {
                this.executeListener.faildConvert(file, "file can't overwrite");
                return;
            }
            if (!this.backup) {
                if (tmpOutput.exists() && this.executeListener != null && !(overwrite = this.executeListener.askOverwrite(tmpOutput))) {
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(file, "file don't overwrite");
                    }
                    return;
                }
            } else {
                boolean r;
                File backUpFile = new File(tmpOutput.getParent(), String.valueOf(tmpOutput.getName()) + ".bk");
                if (backUpFile.exists()) {
                    r = backUpFile.delete();
                    if (!r) {
                        log.warn((Object)("delete faild " + backUpFile));
                    } else {
                        log.info((Object)("delete success " + backUpFile));
                    }
                }
                if (!(r = tmpOutput.renameTo(backUpFile))) {
                    log.warn((Object)("backup faild " + tmpOutput));
                } else {
                    log.info((Object)("backup success " + tmpOutput));
                }
            }
            File input = null;
            File avs = null;
            boolean avsAvailable = false;
            if (this.ffmpegPreference != null) {
                avsAvailable = FFMpegUtils.isAvisynthAvailable(new File(this.ffmpegPreference.getFfmpegPath()));
            }
            int i = 0;
            while (i < this.ignoreAvisynthExtensions.length) {
                if (file.getName().endsWith(this.ignoreAvisynthExtensions[i])) {
                    this.useAvisynth = false;
                    log.info((Object)("dont use avisynth for " + this.ignoreAvisynthExtensions[i]));
                    break;
                }
                ++i;
            }
            if (this.useAvisynth && avsAvailable) {
                try {
                    avs = File.createTempFile("avs", ".avs");
                    FileWriter writer = new FileWriter(avs);
                    writer.write(FFMpegUtils.toAVSScript(file.getAbsolutePath()));
                    writer.close();
                    input = avs;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                input = file;
            }
            String[] commands = this.ffmpegPreference.toCommand(input.getAbsolutePath(), tmpOutput.getAbsolutePath());
            Runtime runtime = Runtime.getRuntime();
            ErrorCatchProcessPrinter printer = new ErrorCatchProcessPrinter();
            try {
                printer.printOutput(FFMpegExecuter.toDebugArray(commands));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            this.process = null;
            try {
                try {
                    this.process = runtime.exec(commands);
                    ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
                    monitor.startMonitor();
                    try {
                        this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    this.process.destroy();
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(file, e1.getMessage());
                    }
                    Object var15_21 = null;
                    if (avs != null) {
                        avs.delete();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                if (avs != null) {
                    avs.delete();
                }
                throw throwable;
            }
            {
                Object var15_23 = null;
                if (avs == null) break block34;
                avs.delete();
            }
        }
        if (this.executeListener != null) {
            this.executeListener.endConvert(file);
        }
        this.process = null;
        this.cancelling = false;
    }

    public static String toDebugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public DirectryBasedExecuterListener getExecuteListener() {
        return this.executeListener;
    }

    public void setExecuteListener(DirectryBasedExecuterListener executeListener) {
        this.executeListener = executeListener;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public FFMpegPreference getFfmpegPreference() {
        return this.ffmpegPreference;
    }

    public void setFfmpegPreference(FFMpegPreference ffmpegPreference) {
        this.ffmpegPreference = ffmpegPreference;
    }

    public String[] getIgnoreAvisynthExtensions() {
        return this.ignoreAvisynthExtensions;
    }

    public void setIgnoreAvisynthExtensions(String[] ignoreAvisynthExtensions) {
        this.ignoreAvisynthExtensions = ignoreAvisynthExtensions;
    }

    public boolean isSameDirectory() {
        return this.sameDirectory;
    }

    public void setSameDirectory(boolean sameDirectory) {
        this.sameDirectory = sameDirectory;
    }

    public boolean isUseAvisynth() {
        return this.useAvisynth;
    }

    public void setUseAvisynth(boolean useAvisynth) {
        this.useAvisynth = useAvisynth;
    }

    public class TestMonitor
    implements DirectryBasedExecuterListener {
        public void beforeConvert() {
        }

        public void afterConvert() {
        }

        public void startConvert(File file) {
        }

        public void endConvert(File file) {
        }

        public void faildConvert(File file, String message) {
            System.out.println("faild:" + file);
        }

        public void printProcess(String line) {
        }

        public boolean askOverwrite(File output) {
            return false;
        }
    }

    public class ErrorCatchProcessPrinter
    implements ProcessPrinter {
        public void printOutput(String output) throws IOException {
            this.print(output);
        }

        public void printError(String error) throws IOException {
            this.print(error);
        }

        private void print(String line) throws IOException {
            if (FFMpegExecuter.this.executeListener != null) {
                FFMpegExecuter.this.executeListener.printProcess(line);
            }
            log.debug((Object)line);
            if (line.indexOf("Unsupported video codec") != -1) {
                throw new IOException("Unsupported video codec");
            }
        }
    }
}

