/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class MPEGConvertTabBuilder
implements IDropSomething {
    private FileOverwriteControler fileOverwriteControler;

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText("MPEG-Videos");
        tabItem1.setControl((Control)new MPEGConvertTab((Composite)tab, 0));
        this.fileOverwriteControler = new FileOverwriteControler(tab.getShell());
    }

    public class MPEGConvertTab
    extends DirectoryBasedDropSomething {
        private FFMpegExecuter ffmpegExecuter;
        private Label dragHere;
        private CCombo typeSelect;

        public MPEGConvertTab(Composite parent, int style) {
            super(parent, style);
        }

        public Composite createControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            this.createDirectoryInfo(composite);
            this.typeSelect = new CCombo(composite, 8);
            this.typeSelect.add(Messages.getString("dvd_352x240_mpeg1_mp2"));
            this.typeSelect.add(Messages.getString("dvd_720x480_mpeg2_ac3"));
            this.typeSelect.add(Messages.getString("dvd_352x240_mpeg2_ac3"));
            this.typeSelect.add(Messages.getString("dvd_720x480_mpeg2_mp2"));
            this.typeSelect.add(Messages.getString("dvd_352x240_mpeg2_mp2"));
            this.typeSelect.select(0);
            this.dragHere = new Label(composite, 0);
            this.dragHere.setLayoutData((Object)new GridData(1808));
            this.setCanConvert(true);
            this.updateStatus();
            return composite;
        }

        public void inconvert(File file) {
            this.ffmpegExecuter.execute(new File[]{file});
        }

        public void beforeConvert() {
            this.ffmpegExecuter = new FFMpegExecuter();
            this.ffmpegExecuter.setExecuteListener(new FFMpegMonitor());
            String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
            FFMpegPreference preference = this.ffmpegExecuter.getFfmpegPreference();
            preference.setFfmpegPath(ffmpegPath);
            preference.setExtension("mpg");
            this.ffmpegExecuter.setSameDirectory(this.samefolder.getSelection());
            this.ffmpegExecuter.setBackup(this.backup.getSelection());
            if (!this.samefolder.getSelection()) {
                this.ffmpegExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            }
            int videoBitrate = 9000;
            int audioBitrate = 256;
            String selectlabel = this.typeSelect.getItem(this.typeSelect.getSelectionIndex());
            if (selectlabel.equals(Messages.getString("dvd_352x240_mpeg1_mp2"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("352x240");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg1video");
                preference.setVideoAspect("4:3");
                preference.setVideoBitrate(videoBitrate);
                preference.setVideoMaxBitrate(videoBitrate);
                preference.setVideoMinBitrate(videoBitrate);
                preference.setAudioCodec("mp2");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            } else if (selectlabel.equals(Messages.getString("dvd_720x480_mpeg2_ac3"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("720x480");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg2video");
                preference.setVideoAspect("4:3");
                preference.setVideoBitrate(videoBitrate);
                preference.setAudioCodec("ac3");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            } else if (selectlabel.equals(Messages.getString("dvd_352x240_mpeg2_ac3"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("352x240");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg2video");
                preference.setVideoAspect("4:3");
                preference.setVideoBitrate(videoBitrate);
                preference.setAudioCodec("ac3");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            } else if (selectlabel.equals(Messages.getString("dvd_352x240_mpeg2_mp2"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("352x240");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg2video");
                preference.setVideoAspect("4:3");
                preference.setVideoBitrate(videoBitrate);
                preference.setAudioCodec("mp2");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            } else if (selectlabel.equals(Messages.getString("dvd_720x480_mpeg2_mp2"))) {
                preference.setTarget("ntsc-dvd");
                preference.setVideoSize("720x480");
                preference.setVideoRate(29.97);
                preference.setVideoCodec("mpeg2video");
                preference.setVideoAspect("4:3");
                preference.setVideoBitrate(videoBitrate);
                preference.setAudioCodec("mp2");
                preference.setAudioRate(48000);
                preference.setAudioChannel(2);
                preference.setAudioBitrate(audioBitrate);
            }
        }

        public void afterConvert() {
        }

        public boolean isCanConvert() {
            String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
            return FFMpegUtils.isFFMpegAvailable(ffmpegPath);
        }

        public void cancelConvert() {
            this.ffmpegExecuter.cancel();
        }

        public void updateStatus() {
            if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                this.setMessage(Messages.getString("dropsomething.drag_folder"));
                this.setCanConvert(true);
            } else {
                this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCanConvert(false);
            }
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        public class FFMpegMonitor
        implements DirectryBasedExecuterListener {
            public void beforeConvert() {
            }

            public void afterConvert() {
            }

            public void startConvert(File file) {
            }

            public void endConvert(File file) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[complete:mpeg]" + file.getAbsolutePath());
            }

            public void faildConvert(File file, String message) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[faild:mpeg]" + message + "," + file.getAbsolutePath());
            }

            public void printProcess(String line) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(line);
            }

            public boolean askOverwrite(File output) {
                return FileOverwriteControler.askOverwrite(MPEGConvertTabBuilder.this.fileOverwriteControler, output);
            }
        }
    }
}

