/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 * MDCChipSetAttributes provides the named constants for attributes used by the
 * foundation.
 */
export var MDCChipSetAttributes;
(function (MDCChipSetAttributes) {
    MDCChipSetAttributes["ARIA_MULTISELECTABLE"] = "aria-multiselectable";
})(MDCChipSetAttributes || (MDCChipSetAttributes = {}));
/**
 * MDCChipSetCssClasses provides the named constants for class names.
 */
export var MDCChipSetCssClasses;
(function (MDCChipSetCssClasses) {
    MDCChipSetCssClasses["CHIP"] = "mdc-evolution-chip";
})(MDCChipSetCssClasses || (MDCChipSetCssClasses = {}));
/**
 * MDCChipSetEvents provides the constants for emitted events.
 */
export var MDCChipSetEvents;
(function (MDCChipSetEvents) {
    MDCChipSetEvents["INTERACTION"] = "MDCChipSet:interaction";
    MDCChipSetEvents["REMOVAL"] = "MDCChipSet:removal";
    MDCChipSetEvents["SELECTION"] = "MDCChipSet:selection";
})(MDCChipSetEvents || (MDCChipSetEvents = {}));
//# sourceMappingURL=constants.js.map