/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;

@Endpoint(id="duoPing", enableByDefault=false)
public class DuoSecurityPingEndpoint
extends BaseCasActuatorEndpoint {
    private final ApplicationContext applicationContext;

    public DuoSecurityPingEndpoint(CasConfigurationProperties casProperties, ApplicationContext applicationContext) {
        super(casProperties);
        this.applicationContext = applicationContext;
    }

    @ReadOperation(produces={"application/json"})
    @Operation(summary="Ping Duo Security given the provider id", parameters={@Parameter(name="providerId")})
    public Map<?, ?> pingDuo(@Nullable String providerId) {
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        LinkedHashMap results = new LinkedHashMap();
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        providers.stream().filter(Objects::nonNull).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).filter(provider -> StringUtils.isBlank((CharSequence)providerId) || provider.matches(providerId)).forEach(p -> {
            DuoSecurityAuthenticationService duoService = p.getDuoAuthenticationService();
            boolean available = duoService.ping();
            results.put(p.getId(), CollectionUtils.wrap((String)"duoApiHost", (Object)resolver.resolve(duoService.getProperties().getDuoApiHost()), (String)"name", (Object)p.getFriendlyName(), (String)"availability", (Object)available));
        });
        return results;
    }
}

