/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.stream.Collectors;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.java.data.AbstractExecutableDatabinder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class ReportDataBinderImpl
extends AbstractExecutableDatabinder
implements ReportDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(ReportDataBinder.class);
    protected final ReportExecDAO reportExecDAO;
    protected final ImplementationDAO implementationDAO;
    protected final SchedulerFactoryBean scheduler;

    public ReportDataBinderImpl(ReportExecDAO reportExecDAO, ImplementationDAO implementationDAO, SchedulerFactoryBean scheduler) {
        this.reportExecDAO = reportExecDAO;
        this.implementationDAO = implementationDAO;
        this.scheduler = scheduler;
    }

    public void getReport(Report report, ReportTO reportTO) {
        report.setName(reportTO.getName());
        report.setMimeType(reportTO.getMimeType());
        report.setFileExt(reportTO.getFileExt());
        report.setCronExpression(reportTO.getCronExpression());
        report.setActive(reportTO.isActive());
        Implementation jobDelegate = this.implementationDAO.find(reportTO.getJobDelegate());
        if (jobDelegate == null || !"REPORT_DELEGATE".equals(jobDelegate.getType())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidImplementation);
            sce.getElements().add("Null or invalid JobDelegate, expected REPORT_DELEGATE");
            throw sce;
        }
        report.setJobDelegate(jobDelegate);
    }

    public ReportTO getReportTO(Report report) {
        ReportTO reportTO = new ReportTO();
        reportTO.setKey(report.getKey());
        reportTO.setName(report.getName());
        reportTO.setMimeType(report.getMimeType());
        reportTO.setFileExt(report.getFileExt());
        reportTO.setCronExpression(report.getCronExpression());
        reportTO.setJobDelegate(report.getJobDelegate().getKey());
        reportTO.setActive(report.isActive());
        ReportExec latestExec = this.reportExecDAO.findLatestStarted(report);
        if (latestExec == null) {
            reportTO.setLatestExecStatus("");
        } else {
            reportTO.setLatestExecStatus(latestExec.getStatus());
            reportTO.setStart(latestExec.getStart());
            reportTO.setEnd(latestExec.getEnd());
            reportTO.setLastExecutor(latestExec.getExecutor());
            reportTO.setLastExec(reportTO.getStart());
        }
        reportTO.getExecutions().addAll(report.getExecs().stream().map(this::getExecTO).collect(Collectors.toList()));
        String triggerName = JobNamer.getTriggerName((String)JobNamer.getJobKey((Report)report).getName());
        try {
            Trigger trigger = this.scheduler.getScheduler().getTrigger(new TriggerKey(triggerName, "DEFAULT"));
            if (trigger != null) {
                reportTO.setLastExec(this.toOffsetDateTime(trigger.getPreviousFireTime()));
                reportTO.setNextExec(this.toOffsetDateTime(trigger.getNextFireTime()));
            }
        }
        catch (SchedulerException e) {
            LOG.warn("While trying to get to " + triggerName, (Throwable)e);
        }
        return reportTO;
    }

    public String buildRefDesc(Report report) {
        return "Report " + report.getKey() + " " + report.getName();
    }

    public ExecTO getExecTO(ReportExec execution) {
        ExecTO execTO = new ExecTO();
        execTO.setKey(execution.getKey());
        execTO.setJobType(JobType.REPORT);
        execTO.setRefKey(execution.getReport().getKey());
        execTO.setRefDesc(this.buildRefDesc(execution.getReport()));
        execTO.setStatus(execution.getStatus());
        execTO.setMessage(execution.getMessage());
        execTO.setStart(execution.getStart());
        execTO.setEnd(execution.getEnd());
        execTO.setExecutor(execution.getExecutor());
        return execTO;
    }
}

