/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.util.EnumSet;

public enum EhcacheMessageType {
    VALIDATE,
    VALIDATE_SERVER_STORE,
    PREPARE_FOR_DESTROY,
    GET_AND_APPEND,
    APPEND,
    REPLACE,
    CLIENT_INVALIDATION_ACK,
    CLIENT_INVALIDATION_ALL_ACK,
    CLEAR,
    GET_STORE,
    LOCK,
    UNLOCK,
    ITERATOR_OPEN,
    ITERATOR_CLOSE,
    ITERATOR_ADVANCE,
    ENABLE_EVENT_LISTENER,
    GET_STATE_REPO,
    PUT_IF_ABSENT,
    ENTRY_SET,
    CHAIN_REPLICATION_OP,
    CLEAR_INVALIDATION_COMPLETE,
    INVALIDATION_COMPLETE,
    MESSAGE_CATCHUP;

    public static final EnumSet<EhcacheMessageType> LIFECYCLE_MESSAGES;
    public static final EnumSet<EhcacheMessageType> STORE_OPERATION_MESSAGES;
    public static final EnumSet<EhcacheMessageType> STATE_REPO_OPERATION_MESSAGES;
    public static final EnumSet<EhcacheMessageType> TRACKED_OPERATION_MESSAGES;
    public static final EnumSet<EhcacheMessageType> PASSIVE_REPLICATION_MESSAGES;

    public static boolean isLifecycleMessage(EhcacheMessageType value) {
        return LIFECYCLE_MESSAGES.contains((Object)value);
    }

    public static boolean isStoreOperationMessage(EhcacheMessageType value) {
        return STORE_OPERATION_MESSAGES.contains((Object)value);
    }

    public static boolean isStateRepoOperationMessage(EhcacheMessageType value) {
        return STATE_REPO_OPERATION_MESSAGES.contains((Object)value);
    }

    public static boolean isTrackedOperationMessage(EhcacheMessageType value) {
        return TRACKED_OPERATION_MESSAGES.contains((Object)value);
    }

    public static boolean isPassiveReplicationMessage(EhcacheMessageType value) {
        return PASSIVE_REPLICATION_MESSAGES.contains((Object)value);
    }

    static {
        LIFECYCLE_MESSAGES = EnumSet.of(VALIDATE, VALIDATE_SERVER_STORE, PREPARE_FOR_DESTROY);
        STORE_OPERATION_MESSAGES = EnumSet.of(GET_AND_APPEND, new EhcacheMessageType[]{APPEND, REPLACE, CLIENT_INVALIDATION_ACK, CLIENT_INVALIDATION_ALL_ACK, CLEAR, GET_STORE, LOCK, UNLOCK, ITERATOR_OPEN, ITERATOR_CLOSE, ITERATOR_ADVANCE, ENABLE_EVENT_LISTENER});
        STATE_REPO_OPERATION_MESSAGES = EnumSet.of(GET_STATE_REPO, PUT_IF_ABSENT, ENTRY_SET);
        TRACKED_OPERATION_MESSAGES = EnumSet.of(CHAIN_REPLICATION_OP, PUT_IF_ABSENT, GET_AND_APPEND, APPEND, CLEAR);
        PASSIVE_REPLICATION_MESSAGES = EnumSet.of(CHAIN_REPLICATION_OP, CLEAR_INVALIDATION_COMPLETE, INVALIDATION_COMPLETE);
    }
}

