/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.config;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.adaptors.duo.DuoSecurityHealthIndicator;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationHandler;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityDirectCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProviderFactory;
import org.apereo.cas.adaptors.duo.web.DuoSecurityAdminApiEndpoint;
import org.apereo.cas.adaptors.duo.web.DuoSecurityPingEndpoint;
import org.apereo.cas.adaptors.duo.web.DuoSecurityUserAccountStatusEndpoint;
import org.apereo.cas.adaptors.duo.web.flow.DuoSecurityMultifactorWebflowConfigurer;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityDetermineUserAccountAction;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityPrepareWebLoginFormAction;
import org.apereo.cas.authentication.AbstractAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBean;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderFactoryBean;
import org.apereo.cas.authentication.bypass.ChainingMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.metadata.MultifactorAuthenticationProviderMetadataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.DirectObjectProvider;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.MultifactorAuthentication, module="duo")
@AutoConfiguration
public class DuoSecurityAuthenticationEventExecutionPlanConfiguration {

    @Configuration(value="DuoSecurityAuthenticationEventExecutionPlanWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationEventExecutionPlanWebConfiguration {
        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DuoSecurityPingEndpoint duoPingEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new DuoSecurityPingEndpoint(casProperties, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DuoSecurityUserAccountStatusEndpoint duoAccountStatusEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new DuoSecurityUserAccountStatusEndpoint(casProperties, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DuoSecurityAdminApiEndpoint duoAdminApiEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new DuoSecurityAdminApiEndpoint(casProperties, (ApplicationContext)applicationContext);
        }
    }

    @Configuration(value="DuoSecurityAuthenticationWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationWebflowActionsConfiguration {
        @ConditionalOnMissingBean(name={"duoMultifactorWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer duoMultifactorWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DuoSecurityMultifactorWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext))).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"duoSecurityCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer duoSecurityCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="duoMultifactorWebflowConfigurer") CasWebflowConfigurer duoMultifactorWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(duoMultifactorWebflowConfigurer)).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"prepareDuoWebLoginFormAction"})
        public Action prepareDuoWebLoginFormAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(DuoSecurityPrepareWebLoginFormAction::new).otherwiseProxy().get()).withId("prepareDuoWebLoginFormAction").build().get();
        }

        @ConditionalOnMissingBean(name={"determineDuoUserAccountAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action determineDuoUserAccountAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(DuoSecurityDetermineUserAccountAction::new).otherwiseProxy().get()).withId("determineDuoUserAccountAction").build().get();
        }
    }

    @Configuration(value="DuoSecurityAuthenticationEventExecutionPlanCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationEventExecutionPlanCoreConfiguration {
        @ConditionalOnMissingBean(name={"duoPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory duoPrincipalFactory(ConfigurableApplicationContext applicationContext) {
            return (PrincipalFactory)BeanSupplier.of(PrincipalFactory.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(PrincipalFactoryUtils::newPrincipalFactory).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"duoProviderFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationProviderFactoryBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorAuthenticationProperties> duoProviderFactory(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<MultifactorAuthenticationPrincipalResolver> resolvers, @Qualifier(value="httpClient") HttpClient httpClient, @Qualifier(value="duoSecurityBypassEvaluator") ChainingMultifactorAuthenticationProviderBypassEvaluator duoSecurityBypassEvaluator, @Qualifier(value="failureModeEvaluator") MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator) {
            return (MultifactorAuthenticationProviderFactoryBean)BeanSupplier.of(MultifactorAuthenticationProviderFactoryBean.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                AnnotationAwareOrderComparator.sort((List)resolvers);
                return new DuoSecurityMultifactorAuthenticationProviderFactory(httpClient, duoSecurityBypassEvaluator, failureModeEvaluator, casProperties, resolvers);
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"duoProviderBean"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationProviderBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorAuthenticationProperties> duoProviderBean(CasConfigurationProperties casProperties, GenericWebApplicationContext applicationContext, @Qualifier(value="duoProviderFactory") MultifactorAuthenticationProviderFactoryBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorAuthenticationProperties> duoProviderFactory) {
            return new MultifactorAuthenticationProviderBean(duoProviderFactory, applicationContext.getDefaultListableBeanFactory(), casProperties.getAuthn().getMfa().getDuo());
        }
    }

    @Configuration(value="DuoSecurityAuthenticationMonitorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationMonitorConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnEnabledHealthIndicator(value="duoSecurityHealthIndicator")
        public HealthIndicator duoSecurityHealthIndicator(ConfigurableApplicationContext applicationContext) {
            return (HealthIndicator)BeanSupplier.of(HealthIndicator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DuoSecurityHealthIndicator((ApplicationContext)applicationContext)).otherwiseProxy().get();
        }
    }

    @Configuration(value="DuoSecurityAuthenticationEventExecutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationEventExecutionConfiguration {
        private static BeanContainer<AuthenticationMetaDataPopulator> duoAuthenticationMetaDataPopulator(ConfigurableApplicationContext applicationContext, DuoSecurityAuthenticationHandler authenticationHandler, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                String authenticationContextAttribute = casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
                AuthenticationContextAttributeMetaDataPopulator p1 = new AuthenticationContextAttributeMetaDataPopulator(casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute(), (AuthenticationHandler)authenticationHandler, ((DuoSecurityMultifactorAuthenticationProvider)authenticationHandler.getMultifactorAuthenticationProvider().getObject()).getId());
                MultifactorAuthenticationProviderMetadataPopulator p2 = new MultifactorAuthenticationProviderMetadataPopulator(authenticationContextAttribute, authenticationHandler.getMultifactorAuthenticationProvider(), (ServicesManager)applicationContext.getBean(ServicesManager.class, new Object[]{ServicesManager.class}));
                return BeanContainer.of((Object[])new BaseAuthenticationMetaDataPopulator[]{p1, p2});
            }).otherwise(BeanContainer::empty).get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"duoAuthenticationHandlers"})
        public BeanContainer<DuoSecurityAuthenticationHandler> duoAuthenticationHandlers(ConfigurableApplicationContext applicationContext, List<MultifactorAuthenticationPrincipalResolver> resolvers, CasConfigurationProperties casProperties, @Qualifier(value="duoPrincipalFactory") PrincipalFactory duoPrincipalFactory, @Qualifier(value="duoProviderBean") MultifactorAuthenticationProviderBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorAuthenticationProperties> duoProviderBean, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                AnnotationAwareOrderComparator.sort((List)resolvers);
                return BeanContainer.of(casProperties.getAuthn().getMfa().getDuo().stream().map(props -> {
                    DuoSecurityMultifactorAuthenticationProvider provider = (DuoSecurityMultifactorAuthenticationProvider)duoProviderBean.getProvider(props.getId());
                    return new DuoSecurityAuthenticationHandler(props.getName(), servicesManager, duoPrincipalFactory, (ObjectProvider)new DirectObjectProvider((Object)provider), Integer.valueOf(props.getOrder()), resolvers);
                }).sorted(Comparator.comparing(AbstractAuthenticationHandler::getOrder)).collect(Collectors.toList()));
            }).otherwise(BeanContainer::empty).get();
        }

        @ConditionalOnMissingBean(name={"duoSecurityAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer duoSecurityAuthenticationEventExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="duoAuthenticationHandlers") BeanContainer<DuoSecurityAuthenticationHandler> duoAuthenticationHandlers) {
            return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                duoAuthenticationHandlers.toList().forEach(dh -> {
                    plan.registerAuthenticationHandler((AuthenticationHandler)dh);
                    BeanContainer<AuthenticationMetaDataPopulator> populators = DuoSecurityAuthenticationEventExecutionConfiguration.duoAuthenticationMetaDataPopulator(applicationContext, dh, casProperties);
                    plan.registerAuthenticationMetadataPopulators((Collection)populators.toList());
                });
                plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{DuoSecurityCredential.class, DuoSecurityDirectCredential.class}));
            }).otherwiseProxy().get();
        }
    }
}

