/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.buttongroup;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.kendo.ui.form.buttongroup.ButtonGroupBehavior;
import com.googlecode.wicket.kendo.ui.form.buttongroup.IButtonGroupListener;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ButtonGroup<T extends Serializable>
extends FormComponentPanel<T>
implements IJQueryWidget,
IButtonGroupListener {
    private static final long serialVersionUID = 1L;
    private IModel<? extends List<T>> choices;
    private FormComponent<Integer> input;
    protected final Options options;

    public ButtonGroup(String id, List<T> choices) {
        this(id, Model.ofList(choices));
    }

    public ButtonGroup(String id, IModel<? extends List<T>> choices) {
        super(id);
        this.choices = this.wrap(choices);
        this.options = new Options();
    }

    public ButtonGroup(String id, IModel<T> model, List<T> choices) {
        this(id, model, Model.ofList(choices));
    }

    public ButtonGroup(String id, IModel<T> model, IModel<? extends List<T>> choices) {
        super(id, model);
        this.choices = this.wrap(choices);
        this.options = new Options();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.input = new HiddenField("value", this.newIndexModel(), Integer.class);
        this.add(new Component[]{this.input.setOutputMarkupId(true)});
        WebMarkupContainer group = new WebMarkupContainer("group");
        this.add(new Component[]{group});
        group.add(new Component[]{new ListView<T>("button", this.choices){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                item.add(new Component[]{ButtonGroup.this.newLabel("label", item.getModel())});
            }
        }});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, (Component)group)});
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("index", this.input.getModelObject());
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    @Override
    public final void onSelect(AjaxRequestTarget target, int index) {
        List choices = (List)this.choices.getObject();
        if (choices != null) {
            this.setModelObject((Serializable)choices.get(index));
            this.onSelect(target, (Serializable)this.getModelObject());
        }
    }

    protected void onSelect(AjaxRequestTarget target, T value) {
    }

    protected boolean isSelectEventEnabled() {
        return false;
    }

    public void convertInput() {
        int index = (Integer)this.input.getConvertedInput();
        List choices = (List)this.choices.getObject();
        if (choices != null && 0 <= index && index < choices.size()) {
            this.setConvertedInput((Serializable)choices.get(index));
        } else {
            this.setConvertedInput(null);
        }
    }

    protected void detachModel() {
        super.detachModel();
        if (this.choices != null) {
            this.choices.detach();
        }
    }

    private IModel<Integer> newIndexModel() {
        return new IModel<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                List choices = (List)ButtonGroup.this.choices.getObject();
                if (choices != null) {
                    return choices.indexOf(ButtonGroup.this.getModelObject());
                }
                return -1;
            }

            public void setObject(Integer index) {
                List choices = (List)ButtonGroup.this.choices.getObject();
                if (choices != null && 0 <= index && index < choices.size()) {
                    ButtonGroup.this.setModelObject((Serializable)choices.get(index));
                }
            }

            public void detach() {
            }
        };
    }

    protected Component newLabel(String id, IModel<T> model) {
        return new Label(id, model);
    }

    public ButtonGroupBehavior newWidgetBehavior(String selector) {
        return new ButtonGroupBehavior(selector, this.options, this){
            private static final long serialVersionUID = 1L;

            @Override
            protected JQueryAjaxBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware source) {
                return new ButtonGroupBehavior.OnSelectAjaxBehavior(source){
                    private static final long serialVersionUID = 1L;

                    public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
                        Object statement = String.format("jQuery('#%s').val(e.index);", ButtonGroup.this.input.getMarkupId());
                        if (ButtonGroup.this.isSelectEventEnabled()) {
                            statement = (String)statement + super.getCallbackFunctionBody(parameters);
                        }
                        return statement;
                    }
                };
            }
        };
    }
}

