/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.revocation;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.X509CRLEntry;
import java.time.ZonedDateTime;
import java.util.Date;
import lombok.Generated;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokedCertificateException
extends GeneralSecurityException {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RevokedCertificateException.class);
    public static final String CRL_REASON_OID = "2.5.29.21";
    private static final long serialVersionUID = 8827788431199129708L;
    private final ZonedDateTime revocationDate;
    private final BigInteger serial;
    private final Reason reason;

    public RevokedCertificateException(ZonedDateTime revoked, BigInteger serial) {
        this(revoked, serial, null);
    }

    public RevokedCertificateException(X509CRLEntry entry) {
        this(DateTimeUtils.zonedDateTimeOf((Date)entry.getRevocationDate()), entry.getSerialNumber(), RevokedCertificateException.getReasonFromX509Entry(entry));
    }

    @Override
    public String getMessage() {
        if (this.reason != null) {
            return String.format("Certificate %s revoked on %s for reason %s", new Object[]{this.serial, this.revocationDate, this.reason});
        }
        return String.format("Certificate %s revoked on %s", this.serial, this.revocationDate);
    }

    private static Reason getReasonFromX509Entry(X509CRLEntry entry) {
        if (entry.hasExtensions()) {
            try {
                int code = Integer.parseInt(new String(entry.getExtensionValue(CRL_REASON_OID), StandardCharsets.US_ASCII));
                if (code < Reason.values().length) {
                    return Reason.fromCode(code);
                }
            }
            catch (Exception e) {
                LOGGER.trace("An exception occurred when resolving extension value: [{}]", (Object)e.getMessage());
            }
        }
        return null;
    }

    @Generated
    public RevokedCertificateException(ZonedDateTime revocationDate, BigInteger serial, Reason reason) {
        this.revocationDate = revocationDate;
        this.serial = serial;
        this.reason = reason;
    }

    @Generated
    public ZonedDateTime getRevocationDate() {
        return this.revocationDate;
    }

    @Generated
    public BigInteger getSerial() {
        return this.serial;
    }

    @Generated
    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        Unspecified,
        KeyCompromise,
        CACompromise,
        AffiliationChanged,
        Superseded,
        CessationOfOperation,
        CertificateHold,
        RemoveFromCRL,
        PrivilegeWithdrawn,
        AACompromise;


        public static Reason fromCode(int code) {
            Reason[] reasons = Reason.values();
            for (int i = 0; i < reasons.length; ++i) {
                if (i != code) continue;
                return reasons[i];
            }
            throw new IllegalArgumentException("Unknown CRL reason code.");
        }
    }
}

