/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.math.BigInteger;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class LongValue
extends ASTNodeAccessImpl
implements Expression {
    private String stringValue;

    public LongValue() {
    }

    public LongValue(String string) {
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        this.stringValue = string;
    }

    public LongValue(long l2) {
        this.stringValue = String.valueOf(l2);
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public long getValue() {
        return Long.parseLong(this.stringValue);
    }

    public BigInteger getBigIntegerValue() {
        return new BigInteger(this.stringValue);
    }

    public void setValue(long l2) {
        this.stringValue = String.valueOf(l2);
    }

    public LongValue withValue(long l2) {
        this.setValue(l2);
        return this;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    public String toString() {
        return this.getStringValue();
    }

    public LongValue withStringValue(String string) {
        this.setStringValue(string);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (LongValue)object;
        return this.stringValue.equals(((LongValue)object).stringValue);
    }

    public int hashCode() {
        return Objects.hash(this.stringValue);
    }
}

