/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import lombok.Generated;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordHistoryProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetTokenCipherExecutor;
import org.apereo.cas.pm.PasswordResetUrlBuilder;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.impl.DefaultPasswordResetUrlBuilder;
import org.apereo.cas.pm.impl.DefaultPasswordValidationService;
import org.apereo.cas.pm.impl.GroovyResourcePasswordManagementService;
import org.apereo.cas.pm.impl.JsonResourcePasswordManagementService;
import org.apereo.cas.pm.impl.NoOpPasswordManagementService;
import org.apereo.cas.pm.impl.history.AmnesiacPasswordHistoryService;
import org.apereo.cas.pm.impl.history.GroovyPasswordHistoryService;
import org.apereo.cas.pm.impl.history.InMemoryPasswordHistoryService;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.BooleanAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.FirstParameterAuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.ShortenedReturnValueAsStringAuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.SpringWebflowActionExecutionAuditablePrincipalResolver;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.PasswordManagement)
@AutoConfiguration
public class PasswordManagementConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementConfiguration.class);

    @Configuration(value="PasswordManagementCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementCoreConfiguration {
        @ConditionalOnMissingBean(name={"passwordResetUrlBuilder"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public PasswordResetUrlBuilder passwordResetUrlBuilder(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordChangeService, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory) {
            return new DefaultPasswordResetUrlBuilder(passwordChangeService, ticketRegistry, ticketFactory, casProperties);
        }

        @ConditionalOnMissingBean(name={"passwordChangeService"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public PasswordManagementService passwordChangeService(CasConfigurationProperties casProperties, @Qualifier(value="passwordManagementCipherExecutor") CipherExecutor passwordManagementCipherExecutor, @Qualifier(value="passwordHistoryService") PasswordHistoryService passwordHistoryService) {
            PasswordManagementProperties pm = casProperties.getAuthn().getPm();
            if (pm.getCore().isEnabled()) {
                Resource location = pm.getJson().getLocation();
                if (location != null) {
                    LOGGER.debug("Configuring password management based on JSON resource [{}]", (Object)location);
                    return new JsonResourcePasswordManagementService(passwordManagementCipherExecutor, casProperties.getServer().getPrefix(), casProperties.getAuthn().getPm(), location, passwordHistoryService);
                }
                Resource groovyScript = pm.getGroovy().getLocation();
                if (groovyScript != null) {
                    LOGGER.debug("Configuring password management based on Groovy resource [{}]", (Object)groovyScript);
                    return new GroovyResourcePasswordManagementService(passwordManagementCipherExecutor, casProperties.getServer().getPrefix(), casProperties.getAuthn().getPm(), groovyScript, passwordHistoryService);
                }
                LOGGER.warn("No storage service is configured to handle the account update and password service operations. Password management functionality will have no effect and will be disabled until a storage service is configured. To explicitly disable the password management, add 'cas.authn.pm.core.enabled=false' to the CAS configuration");
            } else {
                LOGGER.debug("Password management is disabled. To enable the password management functionality, add 'cas.authn.pm.core.enabled=true' to the CAS configuration and then configure storage options for account updates");
            }
            return new NoOpPasswordManagementService(passwordManagementCipherExecutor, casProperties.getServer().getPrefix(), casProperties.getAuthn().getPm());
        }

        @Bean
        public InitializingBean afterPropertiesSet(CasConfigurationProperties casProperties, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager) {
            return () -> {
                PasswordManagementProperties pm = casProperties.getAuthn().getPm();
                if (pm.getCore().isEnabled()) {
                    communicationsManager.validate();
                }
            };
        }
    }

    @Configuration(value="PasswordManagementCipherConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementCipherConfiguration {
        @ConditionalOnMissingBean(name={"passwordManagementCipherExecutor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CipherExecutor passwordManagementCipherExecutor(CasConfigurationProperties casProperties) {
            PasswordManagementProperties pm = casProperties.getAuthn().getPm();
            EncryptionJwtSigningJwtCryptographyProperties crypto = pm.getReset().getCrypto();
            if (pm.getCore().isEnabled() && crypto.isEnabled()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, PasswordResetTokenCipherExecutor.class);
            }
            return CipherExecutor.noOp();
        }
    }

    @Configuration(value="PasswordManagementAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementAuditConfiguration {
        @ConditionalOnMissingBean(name={"passwordManagementReturnValueResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver passwordManagementReturnValueResourceResolver() {
            return new ShortenedReturnValueAsStringAuditResourceResolver();
        }

        @Bean
        @ConditionalOnMissingBean(name={"passwordManagementAuditTrailRecordResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer passwordManagementAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver) {
            return plan -> {
                plan.registerAuditActionResolver("CHANGE_PASSWORD_ACTION_RESOLVER", (AuditActionResolver)new BooleanAuditActionResolver("_SUCCESS", "_FAILED"));
                plan.registerAuditResourceResolver("CHANGE_PASSWORD_RESOURCE_RESOLVER", (AuditResourceResolver)new FirstParameterAuditResourceResolver());
                plan.registerAuditActionResolver("REQUEST_CHANGE_PASSWORD_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver());
                plan.registerAuditResourceResolver("REQUEST_CHANGE_PASSWORD_RESOURCE_RESOLVER", returnValueResourceResolver);
                plan.registerAuditPrincipalResolver("REQUEST_CHANGE_PASSWORD_PRINCIPAL_RESOLVER", (PrincipalResolver)new SpringWebflowActionExecutionAuditablePrincipalResolver("username"));
            };
        }
    }

    @Configuration(value="PasswordManagementHistoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementHistoryConfiguration {
        @ConditionalOnMissingBean(name={"passwordHistoryService"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public PasswordHistoryService passwordHistoryService(CasConfigurationProperties casProperties) {
            PasswordManagementProperties pm = casProperties.getAuthn().getPm();
            PasswordHistoryProperties history = pm.getHistory();
            if (pm.getCore().isEnabled() && history.getCore().isEnabled()) {
                if (history.getGroovy().getLocation() != null) {
                    return new GroovyPasswordHistoryService(history.getGroovy().getLocation());
                }
                return new InMemoryPasswordHistoryService();
            }
            return new AmnesiacPasswordHistoryService();
        }
    }

    @Configuration(value="PasswordManagementValidationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementValidationConfiguration {
        @ConditionalOnMissingBean(name={"passwordValidationService"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public PasswordValidationService passwordValidationService(CasConfigurationProperties casProperties, @Qualifier(value="passwordHistoryService") PasswordHistoryService passwordHistoryService) {
            String policyPattern = casProperties.getAuthn().getPm().getCore().getPasswordPolicyPattern();
            return new DefaultPasswordValidationService(policyPattern, passwordHistoryService);
        }
    }
}

