/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.api.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.ext.scimv2.api.data.Group;
import org.apache.syncope.ext.scimv2.api.data.Meta;
import org.apache.syncope.ext.scimv2.api.data.SCIMComplexValue;
import org.apache.syncope.ext.scimv2.api.data.SCIMEnterpriseInfo;
import org.apache.syncope.ext.scimv2.api.data.SCIMExtensionInfo;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;
import org.apache.syncope.ext.scimv2.api.data.SCIMUserAddress;
import org.apache.syncope.ext.scimv2.api.data.SCIMUserName;
import org.apache.syncope.ext.scimv2.api.data.Value;

@JsonPropertyOrder(value={"schemas", "id", "externalId", "userName", "password", "active", "name", "displayName", "nickName", "profileUrl", "title", "userType", "preferredLanguage", "locale", "timezone", "emails", "phoneNumbers", "ims", "photos", "addresses", "x509Certificates", "groups", "entitlements", "roles", "enterpriseInfo", "extensionInfo", "meta"})
public class SCIMUser
extends SCIMResource {
    private static final long serialVersionUID = -2935466041674390279L;
    private final String userName;
    private String password;
    private final Boolean active;
    private SCIMUserName name;
    private String nickName;
    private String profileUrl;
    private String title;
    private String userType;
    private String preferredLanguage;
    private String locale;
    private String timezone;
    private final List<SCIMComplexValue> emails = new ArrayList<SCIMComplexValue>();
    private final List<SCIMComplexValue> phoneNumbers = new ArrayList<SCIMComplexValue>();
    private final List<SCIMComplexValue> ims = new ArrayList<SCIMComplexValue>();
    private final List<SCIMComplexValue> photos = new ArrayList<SCIMComplexValue>();
    private final List<SCIMUserAddress> addresses = new ArrayList<SCIMUserAddress>();
    private final List<Value> x509Certificates = new ArrayList<Value>();
    private final List<Group> groups = new ArrayList<Group>();
    private final List<Value> entitlements = new ArrayList<Value>();
    private final List<Value> roles = new ArrayList<Value>();
    @JsonProperty(value="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")
    private SCIMEnterpriseInfo enterpriseInfo;
    @JsonProperty(value="urn:ietf:params:scim:schemas:extension:syncope:2.0:User")
    private SCIMExtensionInfo extensionInfo;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SCIMUser(@JsonProperty(value="id") String id, @JsonProperty(value="schemas") List<String> schemas, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="userName") String userName, @JsonProperty(value="active") Boolean active) {
        super(id, schemas, meta);
        this.userName = userName;
        this.active = active;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    @JsonIgnore
    public Boolean getActive() {
        return this.active;
    }

    public boolean isActive() {
        return Optional.ofNullable(this.active).orElse(true);
    }

    public SCIMUserName getName() {
        return this.name;
    }

    public void setName(SCIMUserName name) {
        this.name = name;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public List<SCIMComplexValue> getEmails() {
        return this.emails;
    }

    public List<SCIMComplexValue> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public List<SCIMComplexValue> getIms() {
        return this.ims;
    }

    public List<SCIMComplexValue> getPhotos() {
        return this.photos;
    }

    public List<SCIMUserAddress> getAddresses() {
        return this.addresses;
    }

    public List<Value> getX509Certificates() {
        return this.x509Certificates;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<Value> getEntitlements() {
        return this.entitlements;
    }

    public List<Value> getRoles() {
        return this.roles;
    }

    public SCIMEnterpriseInfo getEnterpriseInfo() {
        return this.enterpriseInfo;
    }

    public void setEnterpriseInfo(SCIMEnterpriseInfo enterpriseInfo) {
        this.enterpriseInfo = enterpriseInfo;
    }

    public SCIMExtensionInfo getExtensionInfo() {
        return this.extensionInfo;
    }

    public void setExtensionInfo(SCIMExtensionInfo extensionInfo) {
        this.extensionInfo = extensionInfo;
    }
}

