/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication;

import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceBypassEvaluator;

public class DefaultMultifactorAuthenticationTrustedDeviceBypassEvaluator
implements MultifactorAuthenticationTrustedDeviceBypassEvaluator {
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    @Override
    public boolean shouldBypassTrustedDevice(RegisteredService registeredService, Service service, Authentication authentication) {
        if (registeredService == null && service == null) {
            return false;
        }
        AuditableContext audit = AuditableContext.builder().service(service).authentication(authentication).registeredService(registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        accessResult.throwExceptionIfNeeded();
        RegisteredServiceMultifactorPolicy mfaPolicy = registeredService != null ? registeredService.getMultifactorAuthenticationPolicy() : null;
        return mfaPolicy != null && mfaPolicy.isBypassTrustedDeviceEnabled();
    }

    @Generated
    public DefaultMultifactorAuthenticationTrustedDeviceBypassEvaluator(AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }
}

