/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;

public class CompositeKeySerializationUtils {
    public static int readKeyGroup(int keyGroupPrefixBytes, DataInputView inputView) throws IOException {
        int keyGroup = 0;
        for (int i = 0; i < keyGroupPrefixBytes; ++i) {
            keyGroup <<= 8;
            keyGroup |= inputView.readByte() & 0xFF;
        }
        return keyGroup;
    }

    public static <K> K readKey(TypeSerializer<K> keySerializer, DataInputDeserializer inputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeRead = inputView.getPosition();
        Object key = keySerializer.deserialize((DataInputView)inputView);
        if (ambiguousKeyPossible) {
            int length = inputView.getPosition() - beforeRead;
            CompositeKeySerializationUtils.readVariableIntBytes((DataInputView)inputView, length);
        }
        return (K)key;
    }

    public static <N> N readNamespace(TypeSerializer<N> namespaceSerializer, DataInputDeserializer inputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeRead = inputView.getPosition();
        Object namespace = namespaceSerializer.deserialize((DataInputView)inputView);
        if (ambiguousKeyPossible) {
            int length = inputView.getPosition() - beforeRead;
            CompositeKeySerializationUtils.readVariableIntBytes((DataInputView)inputView, length);
        }
        return (N)namespace;
    }

    public static <N> void writeNameSpace(N namespace, TypeSerializer<N> namespaceSerializer, DataOutputSerializer keySerializationDataOutputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeWrite = keySerializationDataOutputView.length();
        namespaceSerializer.serialize(namespace, (DataOutputView)keySerializationDataOutputView);
        if (ambiguousKeyPossible) {
            CompositeKeySerializationUtils.writeLengthFrom(beforeWrite, keySerializationDataOutputView);
        }
    }

    public static boolean isSerializerTypeVariableSized(@Nonnull TypeSerializer<?> serializer) {
        return serializer.getLength() < 0;
    }

    public static boolean isAmbiguousKeyPossible(TypeSerializer keySerializer, TypeSerializer namespaceSerializer) {
        return CompositeKeySerializationUtils.isSerializerTypeVariableSized(keySerializer) && CompositeKeySerializationUtils.isSerializerTypeVariableSized(namespaceSerializer);
    }

    public static void writeKeyGroup(int keyGroup, int keyGroupPrefixBytes, DataOutputView keySerializationDateDataOutputView) throws IOException {
        int i = keyGroupPrefixBytes;
        while (--i >= 0) {
            keySerializationDateDataOutputView.writeByte((int)CompositeKeySerializationUtils.extractByteAtPosition(keyGroup, i));
        }
    }

    public static <K> void writeKey(K key, TypeSerializer<K> keySerializer, DataOutputSerializer keySerializationDataOutputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeWrite = keySerializationDataOutputView.length();
        keySerializer.serialize(key, (DataOutputView)keySerializationDataOutputView);
        if (ambiguousKeyPossible) {
            CompositeKeySerializationUtils.writeLengthFrom(beforeWrite, keySerializationDataOutputView);
        }
    }

    public static void readVariableIntBytes(DataInputView inputView, int value) throws IOException {
        do {
            inputView.readByte();
        } while ((value >>>= 8) != 0);
    }

    private static void writeLengthFrom(int fromPosition, DataOutputSerializer keySerializationDateDataOutputView) throws IOException {
        int length = keySerializationDateDataOutputView.length() - fromPosition;
        CompositeKeySerializationUtils.writeVariableIntBytes(length, (DataOutputView)keySerializationDateDataOutputView);
    }

    public static void writeVariableIntBytes(int value, DataOutputView keySerializationDateDataOutputView) throws IOException {
        do {
            keySerializationDateDataOutputView.writeByte(value);
        } while ((value >>>= 8) != 0);
    }

    public static void serializeKeyGroup(int keyGroup, byte[] startKeyGroupPrefixBytes) {
        int keyGroupPrefixBytes = startKeyGroupPrefixBytes.length;
        for (int j = 0; j < keyGroupPrefixBytes; ++j) {
            startKeyGroupPrefixBytes[j] = CompositeKeySerializationUtils.extractByteAtPosition(keyGroup, keyGroupPrefixBytes - j - 1);
        }
    }

    private static byte extractByteAtPosition(int value, int byteIdx) {
        return (byte)(value >>> (byteIdx << 3));
    }

    public static int computeRequiredBytesInKeyGroupPrefix(int totalKeyGroupsInJob) {
        return totalKeyGroupsInJob > 128 ? 2 : 1;
    }
}

