/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.V2TableUtil$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.ExtractV2CatalogAndIdentifier$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.util.SchemaValidationMode;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class V2TableRefreshUtil$
implements SQLConfHelper,
Logging {
    public static final V2TableRefreshUtil$ MODULE$ = new V2TableRefreshUtil$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public LogicalPlan refresh(SparkSession spark, LogicalPlan plan, boolean versionedOnly) {
        return this.refresh(spark, plan, versionedOnly, this.determineSchemaValidationMode(plan));
    }

    public LogicalPlan refresh(SparkSession spark, LogicalPlan plan, boolean versionedOnly, SchemaValidationMode schemaValidationMode) {
        HashMap currentTables = HashMap$.MODULE$.empty();
        return (LogicalPlan)plan.transformWithSubqueries((PartialFunction)new Serializable(versionedOnly, currentTables, spark, schemaValidationMode){
            private static final long serialVersionUID = 0L;
            private final boolean versionedOnly$1;
            private final HashMap currentTables$1;
            private final SparkSession spark$1;
            private final SchemaValidationMode schemaValidationMode$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2Relation dataSourceV2Relation;
                Option option;
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)A1)).isEmpty()) {
                    TableCatalog catalog = (TableCatalog)((Tuple2)option.get())._1();
                    Identifier ident = (Identifier)((Tuple2)option.get())._2();
                    if ((dataSourceV2Relation.isVersioned() || !this.versionedOnly$1) && dataSourceV2Relation.timeTravelSpec().isEmpty()) {
                        Table currentTable = (Table)this.currentTables$1.getOrElseUpdate((Object)new Tuple2((Object)catalog, (Object)ident), (Function0 & Serializable)() -> {
                            String tableName = V2TableUtil$.MODULE$.toQualifiedName((CatalogPlugin)catalog, ident);
                            Option<DataSourceV2Relation> option = V2TableRefreshUtil$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$lookupCachedRelation($this.spark$1, catalog, ident, dataSourceV2Relation.table());
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                DataSourceV2Relation cached = (DataSourceV2Relation)some.value();
                                V2TableRefreshUtil$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Refreshing table metadata for " + tableName + " using shared relation cache");
                                return cached.table();
                            }
                            if (None$.MODULE$.equals(option)) {
                                V2TableRefreshUtil$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Refreshing table metadata for " + tableName + " using catalog");
                                return catalog.loadTable(ident);
                            }
                            throw new MatchError(option);
                        });
                        V2TableRefreshUtil$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateTableIdentity(currentTable, dataSourceV2Relation);
                        V2TableRefreshUtil$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateDataColumns(currentTable, dataSourceV2Relation, this.schemaValidationMode$1);
                        V2TableRefreshUtil$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateMetadataColumns(currentTable, dataSourceV2Relation, this.schemaValidationMode$1);
                        return (B1)dataSourceV2Relation.copy(currentTable, dataSourceV2Relation.copy$default$2(), dataSourceV2Relation.copy$default$3(), dataSourceV2Relation.copy$default$4(), dataSourceV2Relation.copy$default$5(), dataSourceV2Relation.copy$default$6());
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                DataSourceV2Relation dataSourceV2Relation;
                Option option;
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2)).isEmpty() && (dataSourceV2Relation.isVersioned() || !this.versionedOnly$1) && dataSourceV2Relation.timeTravelSpec().isEmpty();
            }
            {
                this.versionedOnly$1 = versionedOnly$1;
                this.currentTables$1 = currentTables$1;
                this.spark$1 = spark$1;
                this.schemaValidationMode$1 = schemaValidationMode$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.datasources.v2.V2TableRefreshUtil$$anonfun$refresh$1 org.apache.spark.sql.connector.catalog.TableCatalog org.apache.spark.sql.connector.catalog.Identifier org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation ), $anonfun$applyOrElse$2(java.lang.String ), $anonfun$applyOrElse$3(java.lang.String )}, serializedLambda);
            }
        });
    }

    public boolean refresh$default$3() {
        return false;
    }

    public Option<DataSourceV2Relation> org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$lookupCachedRelation(SparkSession spark, TableCatalog catalog, Identifier ident, Table table) {
        return CatalogV2Util$.MODULE$.lookupCachedRelation(spark.sharedState().relationCache(), (CatalogPlugin)catalog, ident, table, this.conf());
    }

    private SchemaValidationMode determineSchemaValidationMode(LogicalPlan plan) {
        if (this.containsCommand(plan)) {
            return SchemaValidationMode.PROHIBIT_CHANGES$.MODULE$;
        }
        return SchemaValidationMode.ALLOW_NEW_FIELDS$.MODULE$;
    }

    private boolean containsCommand(LogicalPlan plan) {
        return plan.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)V2TableRefreshUtil$.$anonfun$containsCommand$1(x$1))).isDefined();
    }

    public void org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateTableIdentity(Table currentTable, DataSourceV2Relation relation) {
        if (relation.table().id() != null) {
            String string = relation.table().id();
            String string2 = currentTable.id();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw QueryCompilationErrors$.MODULE$.tableIdChangedAfterAnalysis(relation.name(), relation.table().id(), currentTable.id());
            }
        }
    }

    public void org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateDataColumns(Table currentTable, DataSourceV2Relation relation, SchemaValidationMode mode) {
        Seq errors = V2TableUtil$.MODULE$.validateCapturedColumns(currentTable, relation, mode);
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.columnsChangedAfterAnalysis(relation.name(), errors);
        }
    }

    public void org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateMetadataColumns(Table currentTable, DataSourceV2Relation relation, SchemaValidationMode mode) {
        Seq errors = V2TableUtil$.MODULE$.validateCapturedMetadataColumns(currentTable, relation, mode);
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.metadataColumnsChangedAfterAnalysis(relation.name(), errors);
        }
    }

    public static final /* synthetic */ boolean $anonfun$containsCommand$1(LogicalPlan x$1) {
        return x$1 instanceof Command;
    }

    private V2TableRefreshUtil$() {
    }
}

