/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.Collection;
import java.util.List;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.ByteExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.InExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CollectionContainsMethod
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        Class elementType;
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(Localiser.msg((String)"060016", (Object[])new Object[]{"contains", "CollectionExpression", 1}));
        }
        CollectionExpression collExpr = (CollectionExpression)expr;
        AbstractMemberMetaData mmd = collExpr.getJavaTypeMapping().getMemberMetaData();
        SQLExpression elemExpr = args.get(0);
        if (elemExpr.isParameter() && mmd != null && mmd.getCollection() != null) {
            Class elementCls = this.stmt.getQueryGenerator().getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
            this.stmt.getQueryGenerator().bindParameter(elemExpr.getParameterName(), elementCls);
        }
        if (collExpr instanceof CollectionLiteral) {
            CollectionLiteral lit = (CollectionLiteral)collExpr;
            Collection coll = (Collection)lit.getValue();
            JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
            if (coll == null || coll.isEmpty()) {
                return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, false));
            }
            if (collExpr.isParameter()) {
                this.stmt.getQueryGenerator().useParameterExpressionAsLiteral((CollectionLiteral)collExpr);
            }
            boolean useInExpression = false;
            List<SQLExpression> collElementExprs = lit.getElementExpressions();
            if (collElementExprs != null && !collElementExprs.isEmpty()) {
                SQLExpression collElementExpr2;
                boolean incompatible = true;
                Class elemtype = this.clr.classForName(elemExpr.getJavaTypeMapping().getType());
                for (SQLExpression collElementExpr2 : collElementExprs) {
                    Class collElemType = this.clr.classForName(collElementExpr2.getJavaTypeMapping().getType());
                    if (!this.elementTypeCompatible(elemtype, collElemType)) continue;
                    incompatible = false;
                    break;
                }
                if (incompatible) {
                    return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, false));
                }
                collElementExpr2 = collElementExprs.get(0);
                if (collElementExpr2 instanceof StringExpression || collElementExpr2 instanceof NumericExpression || collElementExpr2 instanceof TemporalExpression || collElementExpr2 instanceof CharacterExpression || collElementExpr2 instanceof ByteExpression || collElementExpr2 instanceof EnumExpression) {
                    useInExpression = true;
                }
            }
            if (useInExpression) {
                SQLExpression[] exprs = collElementExprs != null ? collElementExprs.toArray(new SQLExpression[collElementExprs.size()]) : null;
                return new InExpression(elemExpr, exprs);
            }
            SQLExpression bExpr = null;
            if (collElementExprs != null) {
                for (int i = 0; i < collElementExprs.size(); ++i) {
                    bExpr = bExpr == null ? collElementExprs.get(i).eq(elemExpr) : ((BooleanExpression)bExpr).ior(collElementExprs.get(i).eq(elemExpr));
                }
            }
            if (bExpr != null) {
                bExpr.encloseInParentheses();
            }
            return bExpr;
        }
        if (mmd == null) {
            throw new NucleusUserException("Cannot perform Collection.contains when the field metadata is not provided");
        }
        if (mmd.isSerialized()) {
            throw new NucleusUserException("Cannot perform Collection.contains when the collection is being serialised");
        }
        ApiAdapter api = this.stmt.getRDBMSManager().getApiAdapter();
        if (!api.isPersistable(elementType = this.clr.classForName(mmd.getCollection().getElementType())) && mmd.getJoinMetaData() == null) {
            throw new NucleusUserException("Cannot perform Collection.contains when the collection<Non-Persistable> is not in a join table");
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            boolean useSubquery = this.getNeedsSubquery(collExpr, elemExpr);
            if (elemExpr instanceof UnboundExpression) {
                String varName = ((UnboundExpression)elemExpr).getVariableName();
                String extensionName = "datanucleus.query.jdoql." + varName + ".join";
                String extensionValue = (String)this.stmt.getQueryGenerator().getValueForExtension(extensionName);
                if (extensionValue != null && extensionValue.equalsIgnoreCase("SUBQUERY")) {
                    useSubquery = true;
                } else if (extensionValue != null && extensionValue.equalsIgnoreCase("INNERJOIN")) {
                    useSubquery = false;
                }
            }
            if (useSubquery) {
                return this.containsAsSubquery(collExpr, elemExpr);
            }
            return this.containsAsInnerJoin(collExpr, elemExpr);
        }
        return this.containsAsSubquery(collExpr, elemExpr);
    }

    protected boolean getNeedsSubquery(SQLExpression collExpr, SQLExpression elemExpr) {
        Boolean hasNOT;
        if (elemExpr instanceof UnboundExpression) {
            NucleusLogger.QUERY.debug((Object)(">> collection.contains collExpr=" + collExpr + " elemExpr=" + elemExpr + " elem.variable=" + ((UnboundExpression)elemExpr).getVariableName() + " need to implement check on whether there is a !coll or an OR using just this variable"));
        }
        boolean needsSubquery = false;
        Boolean hasOR = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.OR");
        if (hasOR != null && hasOR.booleanValue()) {
            needsSubquery = true;
        }
        if ((hasNOT = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.NOT")) != null && hasNOT.booleanValue()) {
            needsSubquery = true;
        }
        return needsSubquery;
    }

    protected SQLExpression containsAsInnerJoin(CollectionExpression collExpr, SQLExpression elemExpr) {
        Class varType;
        SQLJoin.JoinType joinType;
        boolean elemIsUnbound = elemExpr instanceof UnboundExpression;
        String varName = null;
        String elemAlias = null;
        String elemType = null;
        if (elemIsUnbound) {
            varName = ((UnboundExpression)elemExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)("collection.contains(" + elemExpr + ") binding unbound variable " + varName + " using INNER JOIN"));
        } else if (!this.stmt.getQueryGenerator().hasExplicitJoins() && (joinType = this.stmt.getJoinTypeForTable(elemExpr.getSQLTable())) == SQLJoin.JoinType.CROSS_JOIN) {
            elemAlias = this.stmt.removeCrossJoin(elemExpr.getSQLTable());
            elemIsUnbound = true;
            elemType = elemExpr.getJavaTypeMapping().getType();
            NucleusLogger.QUERY.debug((Object)("collection.contains(" + elemExpr + ") was previously bound as CROSS JOIN but changing to INNER JOIN"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        AbstractMemberMetaData mmd = collExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(this.clr, storeMgr.getMetaDataManager());
        CollectionTable joinTbl = (CollectionTable)storeMgr.getTable(mmd);
        if (elemIsUnbound && (varType = this.stmt.getQueryGenerator().getTypeOfVariable(varName)) != null) {
            elemType = varType.getName();
            elemCmd = storeMgr.getMetaDataManager().getMetaDataForClass(elemType, this.clr);
        }
        if (elemType == null) {
            elemType = mmd.getCollection().getElementType();
        }
        if (joinTbl != null) {
            SQLTable joinSqlTbl;
            if (elemCmd == null) {
                joinSqlTbl = this.stmt.innerJoin(collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), joinTbl, elemAlias, joinTbl.getOwnerMapping(), null, null);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getElementMapping());
                if (elemIsUnbound) {
                    this.stmt.getQueryGenerator().bindVariable(varName, null, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    this.addRestrictionOnElement(this.stmt, elemIdExpr, elemExpr);
                }
            } else {
                joinSqlTbl = this.stmt.innerJoin(collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                if (!mmd.getCollection().isEmbeddedElement()) {
                    DatastoreClass elemTbl = storeMgr.getDatastoreClass(elemType, this.clr);
                    SQLTable elemSqlTbl = null;
                    if (joinTbl.getElementMapping() instanceof ReferenceMapping && ((ReferenceMapping)joinTbl.getElementMapping()).getMappingStrategy() == 0) {
                        JavaTypeMapping elemMapping = null;
                        JavaTypeMapping[] elemImplMappings = ((ReferenceMapping)joinTbl.getElementMapping()).getJavaTypeMapping();
                        for (int i = 0; i < elemImplMappings.length; ++i) {
                            if (!elemImplMappings[i].getType().equals(elemCmd.getFullClassName())) continue;
                            elemMapping = elemImplMappings[i];
                            break;
                        }
                        elemSqlTbl = this.stmt.innerJoin(joinSqlTbl, elemMapping, joinTbl.getElementMapping(), elemTbl, elemAlias, elemTbl.getIdMapping(), null, null, null);
                    } else {
                        elemSqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), elemTbl, elemAlias, elemTbl.getIdMapping(), null, null);
                    }
                    SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, elemSqlTbl, elemTbl.getIdMapping());
                    if (elemIsUnbound) {
                        this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                    } else {
                        this.addRestrictionOnElement(this.stmt, elemIdExpr, elemExpr);
                    }
                } else {
                    SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getElementMapping());
                    if (elemIsUnbound) {
                        this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                    } else {
                        this.addRestrictionOnElement(this.stmt, elemIdExpr, elemExpr);
                    }
                }
            }
        } else {
            DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? elemTbl.getMemberMapping(mmd.getRelatedMemberMetaData(this.clr)[0]) : elemTbl.getExternalMapping(mmd, 5);
            SQLTable elemSqlTbl = this.stmt.innerJoin(collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), elemTbl, elemAlias, ownerMapping, null, null);
            if (elemIsUnbound) {
                SQLExpression elemIdExpr = null;
                if (!elemType.equals(mmd.getCollection().getElementType())) {
                    DatastoreClass varTbl = storeMgr.getDatastoreClass(elemType, this.clr);
                    SQLTable varSqlTbl = this.stmt.innerJoin(elemSqlTbl, elemTbl.getIdMapping(), varTbl, null, varTbl.getIdMapping(), null, null);
                    elemIdExpr = this.exprFactory.newExpression(this.stmt, varSqlTbl, varTbl.getIdMapping());
                } else {
                    elemIdExpr = this.exprFactory.newExpression(this.stmt, elemSqlTbl, elemTbl.getIdMapping());
                }
                this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
            } else {
                SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, elemSqlTbl, elemTbl.getIdMapping());
                this.addRestrictionOnElement(this.stmt, elemIdExpr, elemExpr);
            }
        }
        JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
        return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
    }

    protected SQLExpression containsAsSubquery(CollectionExpression collExpr, SQLExpression elemExpr) {
        Class varType;
        boolean elemIsUnbound = elemExpr instanceof UnboundExpression;
        String varName = null;
        if (elemIsUnbound) {
            varName = ((UnboundExpression)elemExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)("collection.contains(" + elemExpr + ") binding unbound variable " + varName + " using SUBQUERY"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        AbstractMemberMetaData mmd = collExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(this.clr, storeMgr.getMetaDataManager());
        CollectionTable joinTbl = (CollectionTable)storeMgr.getTable(mmd);
        String elemType = mmd.getCollection().getElementType();
        if (elemIsUnbound && (varType = this.stmt.getQueryGenerator().getTypeOfVariable(varName)) != null) {
            elemType = varType.getName();
            elemCmd = storeMgr.getMetaDataManager().getMetaDataForClass(elemType, this.clr);
        }
        SQLStatement subStmt = null;
        if (joinTbl != null) {
            if (elemCmd == null) {
                subStmt = new SQLStatement(this.stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getElementMapping());
                if (elemIsUnbound) {
                    this.stmt.getQueryGenerator().bindVariable(varName, null, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    this.addRestrictionOnElement(subStmt, elemIdExpr, elemExpr);
                }
            } else {
                DatastoreClass elemTbl = storeMgr.getDatastoreClass(elemType, this.clr);
                subStmt = new SQLStatement(this.stmt, storeMgr, elemTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), elemTbl.getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                if (elemIsUnbound) {
                    this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    this.addRestrictionOnElement(subStmt, elemIdExpr, elemExpr);
                }
            }
        } else {
            DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
            subStmt = new SQLStatement(this.stmt, storeMgr, elemTbl, null, null);
            subStmt.setClassLoaderResolver(this.clr);
            JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
            subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? elemTbl.getMemberMapping(mmd.getRelatedMemberMetaData(this.clr)[0]) : elemTbl.getExternalMapping(mmd, 5);
            SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
            SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
            subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
            if (elemIsUnbound) {
                SQLExpression elemIdExpr = null;
                if (!elemType.equals(mmd.getCollection().getElementType())) {
                    DatastoreClass varTbl = storeMgr.getDatastoreClass(elemType, this.clr);
                    SQLTable varSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), elemTbl.getIdMapping(), varTbl, null, varTbl.getIdMapping(), null, null);
                    elemIdExpr = this.exprFactory.newExpression(subStmt, varSqlTbl, varTbl.getIdMapping());
                } else {
                    elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                }
                this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
            } else {
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                this.addRestrictionOnElement(subStmt, elemIdExpr, elemExpr);
            }
        }
        return new BooleanSubqueryExpression(this.stmt, "EXISTS", subStmt);
    }

    protected void addRestrictionOnElement(SQLStatement stmt, SQLExpression elemIdExpr, SQLExpression elemExpr) {
        try {
            stmt.whereAnd(elemIdExpr.eq(elemExpr), true);
        }
        catch (IllegalExpressionOperationException ieoe) {
            NucleusLogger.QUERY.warn((Object)("Collection.contains element expression supplied is inconsistent with element type of this collection : " + ieoe.getMessage()));
            JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
            BooleanExpression notContainedExpr = this.exprFactory.newLiteral(stmt, m, false).eq(this.exprFactory.newLiteral(stmt, m, true));
            stmt.whereAnd(notContainedExpr, true);
        }
    }

    protected boolean elementTypeCompatible(Class elementType, Class collectionElementType) {
        if (!elementType.isPrimitive() && collectionElementType.isPrimitive() && !collectionElementType.isAssignableFrom(elementType) && !elementType.isAssignableFrom(collectionElementType)) {
            return false;
        }
        if (elementType.isPrimitive()) {
            if (elementType == Boolean.TYPE && collectionElementType == Boolean.class) {
                return true;
            }
            if (elementType == Byte.TYPE && collectionElementType == Byte.class) {
                return true;
            }
            if (elementType == Character.TYPE && collectionElementType == Character.class) {
                return true;
            }
            if (elementType == Double.TYPE && collectionElementType == Double.class) {
                return true;
            }
            if (elementType == Float.TYPE && collectionElementType == Float.class) {
                return true;
            }
            if (elementType == Integer.TYPE && collectionElementType == Integer.class) {
                return true;
            }
            if (elementType == Long.TYPE && collectionElementType == Long.class) {
                return true;
            }
            return elementType == Short.TYPE && collectionElementType == Short.class;
        }
        return true;
    }
}

