/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkUserAppException;
import org.apache.spark.SparkUserAppException$;
import org.apache.spark.api.python.Py4JServer;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.json4s.JValue;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class PythonRunner$ {
    public static final PythonRunner$ MODULE$ = new PythonRunner$();

    public void main(String[] args) {
        String apiMode;
        String pythonFile = args[0];
        String pyFiles = args[1];
        String[] otherArgs = (String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])args), 2, args.length);
        SparkConf sparkConf = new SparkConf();
        String pythonExec = (String)((Option)sparkConf.get(package$.MODULE$.PYSPARK_DRIVER_PYTHON())).orElse((Function0 & Serializable)() -> (Option)sparkConf.get(package$.MODULE$.PYSPARK_PYTHON())).orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_DRIVER_PYTHON")).orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_PYTHON")).getOrElse((Function0 & Serializable)() -> "python3");
        String formattedPythonFile = this.formatPath(pythonFile, this.formatPath$default$2());
        String[] formattedPyFiles = this.resolvePyFiles(this.formatPaths(pyFiles, this.formatPaths$default$2()));
        String string = apiMode = sparkConf.get(package$.MODULE$.SPARK_API_MODE()).toLowerCase(Locale.ROOT);
        String string2 = "classic";
        boolean isAPIModeClassic = !(string != null ? !string.equals(string2) : string2 != null);
        String string3 = apiMode;
        String string4 = "connect";
        boolean isAPIModeConnect = !(string3 != null ? !string3.equals(string4) : string4 != null);
        ObjectRef gatewayServer = ObjectRef.create((Object)None$.MODULE$);
        if (sparkConf.getOption("spark.remote").isEmpty() || isAPIModeClassic) {
            gatewayServer.elem = new Some((Object)new Py4JServer(sparkConf));
            Thread thread = new Thread(() -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable)() -> ((Py4JServer)((Option)gatewayServer$1.elem).get()).start()));
            thread.setName("py4j-gateway-init");
            thread.setDaemon(true);
            thread.start();
            thread.join();
        }
        ArrayBuffer pathElements = new ArrayBuffer();
        pathElements.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])formattedPyFiles));
        pathElements.$plus$eq((Object)PythonUtils$.MODULE$.sparkPythonPath());
        pathElements.$plus$eq(scala.sys.package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> ""));
        String pythonPath = PythonUtils$.MODULE$.mergePythonPaths((scala.collection.immutable.Seq<String>)pathElements.toSeq());
        ProcessBuilder builder = new ProcessBuilder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)pythonExec, (List)new .colon.colon((Object)formattedPythonFile, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])otherArgs))).asJava());
        Map<String, String> env = builder.environment();
        if (sparkConf.getOption("spark.remote").nonEmpty() || isAPIModeConnect) {
            scala.collection.immutable.Seq grouped = Predef$.MODULE$.wrapRefArray((Object[])sparkConf.getAll()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).grouped(10).toSeq();
            env.put("PYSPARK_REMOTE_INIT_CONF_LEN", Integer.toString(grouped.length()));
            ((IterableOnceOps)grouped.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    scala.collection.immutable.Map group = (scala.collection.immutable.Map)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    return env.put("PYSPARK_REMOTE_INIT_CONF_" + idx, JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)JsonDSL$.MODULE$.map2jvalue(group, (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        if (isAPIModeClassic) {
            sparkConf.getOption("spark.master").foreach((Function1 & Serializable)url -> env.put("MASTER", (String)url));
        } else {
            sparkConf.getOption("spark.remote").foreach((Function1 & Serializable)url -> env.put("SPARK_REMOTE", (String)url));
        }
        env.put("PYTHONPATH", pythonPath);
        env.put("PYTHONUNBUFFERED", "YES");
        ((Option)gatewayServer.elem).foreach((Function1 & Serializable)s -> env.put("PYSPARK_GATEWAY_PORT", Integer.toString(s.getListeningPort())));
        ((Option)gatewayServer.elem).foreach((Function1 & Serializable)s -> env.put("PYSPARK_GATEWAY_SECRET", s.secret()));
        ((Option)sparkConf.get(package$.MODULE$.PYSPARK_PYTHON())).foreach((Function1 & Serializable)x$1 -> env.put("PYSPARK_PYTHON", (String)x$1));
        scala.sys.package$.MODULE$.env().get((Object)"PYTHONHASHSEED").foreach((Function1 & Serializable)x$2 -> env.put("PYTHONHASHSEED", (String)x$2));
        if (sparkConf.getOption("spark.yarn.appMasterEnv.OMP_NUM_THREADS").isEmpty() && sparkConf.getOption("spark.kubernetes.driverEnv.OMP_NUM_THREADS").isEmpty()) {
            sparkConf.getOption("spark.driver.cores").foreach((Function1 & Serializable)x$3 -> env.put("OMP_NUM_THREADS", (String)x$3));
        }
        builder.redirectErrorStream(true);
        try {
            Process process = builder.start();
            new RedirectThread(process.getInputStream(), System.out, "redirect output", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new SparkUserAppException(exitCode, SparkUserAppException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        finally {
            ((Option)gatewayServer.elem).foreach((Function1 & Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    public String formatPath(String path, boolean testWindows) {
        String formattedPath;
        block11: {
            block10: {
                String string;
                block9: {
                    if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.nonLocalPaths(path, testWindows)))) {
                        throw new IllegalArgumentException("Launching Python applications through spark-submit is currently only supported for local files: " + path);
                    }
                    URI uri = (URI)Try$.MODULE$.apply((Function0 & Serializable)() -> new URI(path)).getOrElse((Function0 & Serializable)() -> new File(path).toURI());
                    String string2 = uri.getScheme();
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 0: {
                            if (string2 != null) break block9;
                            string = path;
                            break block10;
                        }
                        case 3143036: {
                            if ("file".equals(string2)) {
                                break;
                            }
                            break block9;
                        }
                        case 103145323: {
                            if ("local".equals(string2)) {
                                break;
                            }
                            break block9;
                        }
                        default: {
                            break block9;
                        }
                    }
                    string = uri.getPath();
                    break block10;
                }
                string = formattedPath = null;
            }
            if (formattedPath == null) {
                throw new IllegalArgumentException("Python file path is malformed: " + path);
            }
            if (!Utils$.MODULE$.isWindows() || !formattedPath.matches("/[a-zA-Z]:/.*")) break block11;
            formattedPath = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(formattedPath), "/");
        }
        return formattedPath;
    }

    public boolean formatPath$default$2() {
        return false;
    }

    public String[] formatPaths(String paths, boolean testWindows) {
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])((String)Option$.MODULE$.apply((Object)paths).getOrElse((Function0 & Serializable)() -> "")).split(",")), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5))))), (Function1 & Serializable)p -> MODULE$.formatPath((String)p, testWindows), ClassTag$.MODULE$.apply(String.class));
    }

    public boolean formatPaths$default$2() {
        return false;
    }

    private String[] resolvePyFiles(String[] pyFiles) {
        LazyRef dest$lzy = new LazyRef();
        return (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])pyFiles), (Function1 & Serializable)pyFile -> {
            if (pyFile.endsWith(".py")) {
                File source = new File((String)pyFile);
                if (source.exists() && source.isFile() && source.canRead()) {
                    Files.copy(source.toPath(), new File(PythonRunner$.dest$1(dest$lzy), source.getName()).toPath(), new CopyOption[0]);
                    return new Some((Object)PythonRunner$.dest$1(dest$lzy).getAbsolutePath());
                }
                return None$.MODULE$;
            }
            return new Some(pyFile);
        }, ClassTag$.MODULE$.apply(String.class))));
    }

    private static final /* synthetic */ File dest$lzycompute$1(LazyRef dest$lzy$1) {
        File file;
        LazyRef lazyRef = dest$lzy$1;
        synchronized (lazyRef) {
            File file2;
            if (dest$lzy$1.initialized()) {
                file2 = (File)dest$lzy$1.value();
            } else {
                String x$1 = "localPyFiles";
                String x$2 = Utils$.MODULE$.createTempDir$default$1();
                file2 = (File)dest$lzy$1.initialize((Object)Utils$.MODULE$.createTempDir(x$2, "localPyFiles"));
            }
            file = file2;
        }
        return file;
    }

    private static final File dest$1(LazyRef dest$lzy$1) {
        if (dest$lzy$1.initialized()) {
            return (File)dest$lzy$1.value();
        }
        return PythonRunner$.dest$lzycompute$1(dest$lzy$1);
    }

    private PythonRunner$() {
    }
}

