/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class LongValueBoundaryScanner
extends SingleValueBoundaryScanner {
    public LongValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef) {
        super(start, end, expressionDef);
    }

    @Override
    public boolean isDistanceGreater(Object v1, Object v2, int amt) {
        if (v1 != null && v2 != null) {
            long l2;
            long l1 = PrimitiveObjectInspectorUtils.getLong((Object)v1, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()));
            return l1 - (l2 = PrimitiveObjectInspectorUtils.getLong((Object)v2, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()))) > (long)amt;
        }
        return v1 != null || v2 != null;
    }

    @Override
    public boolean isEqual(Object v1, Object v2) {
        if (v1 != null && v2 != null) {
            long l2;
            long l1 = PrimitiveObjectInspectorUtils.getLong((Object)v1, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()));
            return l1 == (l2 = PrimitiveObjectInspectorUtils.getLong((Object)v2, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI())));
        }
        return v1 == null && v2 == null;
    }
}

