/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hive.metastore.hbase.HbaseMetastoreProto;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionKeyComparator
extends ByteArrayComparable {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionKeyComparator.class);
    String names;
    String types;
    List<Range> ranges;
    List<NativeRange> nativeRanges;
    List<Operator> ops;
    List<NativeOperator> nativeOps;
    Properties serdeProps;

    public PartitionKeyComparator(String names, String types, List<Range> ranges, List<Operator> ops) {
        super(null);
        ObjectInspectorConverters.Converter converter;
        ObjectInspector outputOI;
        TypeInfo expectedType;
        int i;
        this.names = names;
        this.types = types;
        this.ranges = ranges;
        this.ops = ops;
        this.serdeProps = new Properties();
        this.serdeProps.setProperty("columns", "dbName,tableName," + names);
        this.serdeProps.setProperty("columns.types", "string,string," + types);
        this.nativeRanges = new ArrayList<NativeRange>(this.ranges.size());
        for (i = 0; i < ranges.size(); ++i) {
            Range range = ranges.get(i);
            NativeRange nativeRange = new NativeRange();
            this.nativeRanges.add(i, nativeRange);
            nativeRange.pos = Arrays.asList(names.split(",")).indexOf(range.keyName);
            expectedType = TypeInfoUtils.getTypeInfoFromTypeString((String)types.split(",")[nativeRange.pos]);
            outputOI = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)expectedType);
            nativeRange.start = null;
            if (range.start != null) {
                converter = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)outputOI);
                nativeRange.start = (Comparable)converter.convert((Object)range.start.value);
            }
            nativeRange.end = null;
            if (range.end == null) continue;
            converter = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)outputOI);
            nativeRange.end = (Comparable)converter.convert((Object)range.end.value);
        }
        this.nativeOps = new ArrayList<NativeOperator>(this.ops.size());
        for (i = 0; i < ops.size(); ++i) {
            Operator op = ops.get(i);
            NativeOperator nativeOp = new NativeOperator();
            this.nativeOps.add(i, nativeOp);
            nativeOp.pos = ArrayUtils.indexOf((Object[])names.split(","), (Object)op.keyName);
            expectedType = TypeInfoUtils.getTypeInfoFromTypeString((String)types.split(",")[nativeOp.pos]);
            outputOI = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)expectedType);
            converter = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)outputOI);
            nativeOp.val = (Comparable)converter.convert((Object)op.val);
        }
    }

    public static PartitionKeyComparator parseFrom(byte[] bytes) {
        HbaseMetastoreProto.PartitionKeyComparator proto;
        try {
            proto = HbaseMetastoreProto.PartitionKeyComparator.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (HbaseMetastoreProto.PartitionKeyComparator.Range range : proto.getRangeList()) {
            Mark start = null;
            if (range.hasStart()) {
                start = new Mark(range.getStart().getValue(), range.getStart().getInclusive());
            }
            Mark end = null;
            if (range.hasEnd()) {
                end = new Mark(range.getEnd().getValue(), range.getEnd().getInclusive());
            }
            ranges.add(new Range(range.getKey(), start, end));
        }
        ArrayList<Operator> ops = new ArrayList<Operator>();
        for (HbaseMetastoreProto.PartitionKeyComparator.Operator op : proto.getOpList()) {
            ops.add(new Operator(Operator.Type.valueOf(op.getType().name()), op.getKey(), op.getVal()));
        }
        return new PartitionKeyComparator(proto.getNames(), proto.getTypes(), ranges, ops);
    }

    public byte[] toByteArray() {
        int i;
        HbaseMetastoreProto.PartitionKeyComparator.Builder builder = HbaseMetastoreProto.PartitionKeyComparator.newBuilder();
        builder.setNames(this.names);
        builder.setTypes(this.types);
        for (i = 0; i < this.ranges.size(); ++i) {
            Range range = this.ranges.get(i);
            HbaseMetastoreProto.PartitionKeyComparator.Mark startMark = null;
            if (range.start != null) {
                startMark = HbaseMetastoreProto.PartitionKeyComparator.Mark.newBuilder().setValue(range.start.value).setInclusive(range.start.inclusive).build();
            }
            HbaseMetastoreProto.PartitionKeyComparator.Mark endMark = null;
            if (range.end != null) {
                endMark = HbaseMetastoreProto.PartitionKeyComparator.Mark.newBuilder().setValue(range.end.value).setInclusive(range.end.inclusive).build();
            }
            HbaseMetastoreProto.PartitionKeyComparator.Range.Builder rangeBuilder = HbaseMetastoreProto.PartitionKeyComparator.Range.newBuilder();
            rangeBuilder.setKey(range.keyName);
            if (startMark != null) {
                rangeBuilder.setStart(startMark);
            }
            if (endMark != null) {
                rangeBuilder.setEnd(endMark);
            }
            builder.addRange(rangeBuilder.build());
        }
        for (i = 0; i < this.ops.size(); ++i) {
            Operator op = this.ops.get(i);
            builder.addOp(HbaseMetastoreProto.PartitionKeyComparator.Operator.newBuilder().setKey(op.keyName).setType(HbaseMetastoreProto.PartitionKeyComparator.Operator.Type.valueOf(op.type.toString())).setVal(op.val).build());
        }
        return builder.build().toByteArray();
    }

    public int compareTo(byte[] value, int offset, int length) {
        int i;
        byte[] bytes = Arrays.copyOfRange(value, offset, offset + length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get key " + new String(bytes));
        }
        BinarySortableSerDe serDe = new BinarySortableSerDe();
        List deserializedkeys = null;
        try {
            serDe.initialize(new Configuration(), this.serdeProps);
            deserializedkeys = ((List)serDe.deserialize((Writable)new BytesWritable(bytes))).subList(2, 2 + this.names.split(",").length);
        }
        catch (SerDeException e) {
            return 1;
        }
        for (i = 0; i < this.ranges.size(); ++i) {
            Range range = this.ranges.get(i);
            NativeRange nativeRange = this.nativeRanges.get(i);
            Comparable partVal = (Comparable)deserializedkeys.get(nativeRange.pos);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try to match range " + partVal + ", start " + nativeRange.start + ", end " + nativeRange.end);
            }
            if ((range.start == null || range.start.inclusive && partVal.compareTo(nativeRange.start) >= 0 || !range.start.inclusive && partVal.compareTo(nativeRange.start) > 0) && (range.end == null || range.end.inclusive && partVal.compareTo(nativeRange.end) <= 0 || !range.end.inclusive && partVal.compareTo(nativeRange.end) < 0)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fail to match range " + range.keyName + "-" + partVal + "[" + nativeRange.start + "," + nativeRange.end + "]");
            }
            return 1;
        }
        block7: for (i = 0; i < this.ops.size(); ++i) {
            Operator op = this.ops.get(i);
            NativeOperator nativeOp = this.nativeOps.get(i);
            switch (op.type) {
                case LIKE: {
                    if (deserializedkeys.get(nativeOp.pos).toString().matches(op.val)) continue block7;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Fail to match operator " + op.keyName + "(" + deserializedkeys.get(nativeOp.pos) + ") LIKE " + nativeOp.val);
                    }
                    return 1;
                }
                case NOTEQUALS: {
                    if (!nativeOp.val.equals(deserializedkeys.get(nativeOp.pos))) continue block7;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Fail to match operator " + op.keyName + "(" + deserializedkeys.get(nativeOp.pos) + ")!=" + nativeOp.val);
                    }
                    return 1;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("All conditions satisfied:" + deserializedkeys);
        }
        return 0;
    }

    static class NativeOperator {
        int pos;
        Comparable val;

        NativeOperator() {
        }
    }

    static class Operator {
        Type type;
        String keyName;
        String val;

        public Operator(Type type, String keyName, String val) {
            this.type = type;
            this.keyName = keyName;
            this.val = val;
        }

        static enum Type {
            LIKE,
            NOTEQUALS;

        }
    }

    static class NativeRange {
        int pos;
        Comparable start;
        Comparable end;

        NativeRange() {
        }
    }

    static class Range {
        String keyName;
        Mark start;
        Mark end;

        Range(String keyName, Mark start, Mark end) {
            this.keyName = keyName;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "" + this.keyName + ":" + (this.start != null ? this.start.toString() : "") + (this.end != null ? this.end.toString() : "");
        }
    }

    static class Mark {
        String value;
        boolean inclusive;

        Mark(String value, boolean inclusive) {
            this.value = value;
            this.inclusive = inclusive;
        }

        public String toString() {
            return this.value + (this.inclusive ? "_" : "");
        }
    }
}

