/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.st;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.st.STExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.st.ST_SetSrid$;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.STUtils;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeographyType$;
import org.apache.spark.sql.types.GeometryType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(geo, srid) - Returns a new GEOGRAPHY or GEOMETRY value whose SRID is the specified SRID value.", arguments="\n    Arguments:\n      * geo - A GEOGRAPHY or GEOMETRY value.\n      * srid - The new SRID value of the geography or geometry.\n  ", examples="\n    Examples:\n      > SELECT st_srid(_FUNC_(ST_GeogFromWKB(X'0101000000000000000000F03F0000000000000040'), 4326));\n       4326\n      > SELECT st_srid(_FUNC_(ST_GeomFromWKB(X'0101000000000000000000F03F0000000000000040'), 3857));\n       3857\n  ", since="4.1.0", group="st_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001B\u000f\u001f\u00016B\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t%\u0002\u0011\t\u0012)A\u0005]!A1\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003/\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Y\u0006\u0001\"\u0011]\u0011!1\u0007\u0001#b\u0001\n\u0003\n\u0006\"B4\u0001\t\u0003B\u0007\"B9\u0001\t\u0003\n\u0006\"\u0002:\u0001\t\u0003\n\u0006\"B:\u0001\t#\"\bbB=\u0001\u0003\u0003%\tA\u001f\u0005\b{\u0002\t\n\u0011\"\u0001\u007f\u0011!\t\u0019\u0002AI\u0001\n\u0003q\b\"CA\u000b\u0001\u0005\u0005I\u0011IA\f\u0011%\t9\u0003AA\u0001\n\u0003\tI\u0003C\u0005\u00022\u0001\t\t\u0011\"\u0001\u00024!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\t\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#B\u0011\"a\u0017\u0001\u0003\u0003%\t%!\u0018\t\u0013\u0005\u0005\u0004!!A\u0005B\u0005\rt!CAG=\u0005\u0005\t\u0012AAH\r!ib$!A\t\u0002\u0005E\u0005BB+\u0018\t\u0003\tI\u000bC\u0005\u0002,^\t\t\u0011\"\u0012\u0002.\"I\u0011qV\f\u0002\u0002\u0013\u0005\u0015\u0011\u0017\u0005\n\u0003o;\u0012\u0011!CA\u0003sC\u0011\"a3\u0018\u0003\u0003%I!!4\u0003\u0015M#vlU3u'JLGM\u0003\u0002 A\u0005\u00111\u000f\u001e\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M9\u0001A\f\u001a6qy\"\u0005CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003_MJ!\u0001\u000e\u0011\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003_YJ!a\u000e\u0011\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042!\u000f\u001f/\u001b\u0005Q$BA\u001e#\u0003\u0015!(/Z3t\u0013\ti$H\u0001\u0006CS:\f'/\u001f'jW\u0016\u0004\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002F\u001b:\u0011ai\u0013\b\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u00132\na\u0001\u0010:p_Rt\u0014\"A!\n\u00051\u0003\u0015a\u00029bG.\fw-Z\u0005\u0003\u001d>\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0014!\u0002\u0007\u001d,w.F\u0001/\u0003\u00119Wm\u001c\u0011\u0002\tM\u0014\u0018\u000eZ\u0001\u0006gJLG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007]K&\f\u0005\u0002Y\u00015\ta\u0004C\u0003Q\u000b\u0001\u0007a\u0006C\u0003T\u000b\u0001\u0007a&\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0018\t\u0004\u000bz\u0003\u0017BA0P\u0005\r\u0019V-\u001d\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u0012\nQ\u0001^=qKNL!!\u001a2\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017a\u0003:fa2\f7-Z7f]R\f!\u0002\u001d:fiRLh*Y7f+\u0005I\u0007C\u00016o\u001d\tYG\u000e\u0005\u0002H\u0001&\u0011Q\u000eQ\u0001\u0007!J,G-\u001a4\n\u0005=\u0004(AB*ue&twM\u0003\u0002n\u0001\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002Xk^DQA^\u0006A\u00029\nqA\\3x\u0019\u00164G\u000fC\u0003y\u0017\u0001\u0007a&\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u0007][H\u0010C\u0004Q\u0019A\u0005\t\u0019\u0001\u0018\t\u000fMc\u0001\u0013!a\u0001]\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A@+\u00079\n\ta\u000b\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011!C;oG\",7m[3e\u0015\r\ti\u0001Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\t\u0003\u000f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\r!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\tA\u0001\\1oO*\u0011\u00111E\u0001\u0005U\u00064\u0018-C\u0002p\u0003;\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000b\u0011\u0007}\ni#C\u0002\u00020\u0001\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000e\u0002<A\u0019q(a\u000e\n\u0007\u0005e\u0002IA\u0002B]fD\u0011\"!\u0010\u0012\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0005\u0005\u0004\u0002F\u0005-\u0013QG\u0007\u0003\u0003\u000fR1!!\u0013A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\n9E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA*\u00033\u00022aPA+\u0013\r\t9\u0006\u0011\u0002\b\u0005>|G.Z1o\u0011%\tidEA\u0001\u0002\u0004\t)$\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\r\u0003?B\u0011\"!\u0010\u0015\u0003\u0003\u0005\r!a\u000b\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019&!\u001a\t\u0013\u0005uR#!AA\u0002\u0005U\u0002f\u0006\u0001\u0002j\u0005=\u0014\u0011OA;\u0003o\nY(! \u0002\u0002\u0006\r\u0015qQAE!\ry\u00131N\u0005\u0004\u0003[\u0002#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003g\nQm\u0018$V\u001d\u000e{\u0006fZ3pY\u0001\u001a(/\u001b3*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011oK^\u0004s)R(H%\u0006\u0003\u0006*\u0017\u0011pe\u0002:UiT'F)JK\u0006E^1mk\u0016\u0004s\u000f[8tK\u0002\u001a&+\u0013#!SN\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u00043KU%EAY\fG.^3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002z\u0005y(\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011hK>\u0004S\u0006I!!\u000f\u0016{uIU!Q\u0011f\u0003sN\u001d\u0011H\u000b>kU\t\u0016*ZAY\fG.^3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001a(/\u001b3![\u0001\"\u0006.\u001a\u0011oK^\u00043KU%EAY\fG.^3!_\u001a\u0004C\u000f[3!O\u0016|wM]1qQf\u0004sN\u001d\u0011hK>lW\r\u001e:z])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty(AAt\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u001aHoX:sS\u0012DsLR+O\u0007~C3\u000bV0HK><gI]8n/.\u0013\u0005\u0006W\u00141cA\n\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191\rB\u001ad\t\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\u000e\u0019(S1\u0002Cg\r\u001a7S%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005N\u001a3m)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033\u000f^0te&$\u0007f\u0018$V\u001d\u000e{\u0006f\u0015+`\u000f\u0016|WN\u0012:p[^[%\t\u000b-(aE\u0002\u0014\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191a\u0019\u00034G\u0012\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u001b1O%b\u0003e\r\u001d6o%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a9k]R\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u000b\u000bQ\u0001\u000e\u00182]A\nQa\u001a:pkB\f#!a#\u0002\u0011M$xLZ;oGN\f!b\u0015+`'\u0016$8K]5e!\tAvcE\u0003\u0018\u0003'\u000by\nE\u0004\u0002\u0016\u0006meFL,\u000e\u0005\u0005]%bAAM\u0001\u00069!/\u001e8uS6,\u0017\u0002BAO\u0003/\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t\t+a*\u000e\u0005\u0005\r&\u0002BAS\u0003C\t!![8\n\u00079\u000b\u0019\u000b\u0006\u0002\u0002\u0010\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u001a\u0005)\u0011\r\u001d9msR)q+a-\u00026\")\u0001K\u0007a\u0001]!)1K\u0007a\u0001]\u00059QO\\1qa2LH\u0003BA^\u0003\u000f\u0004RaPA_\u0003\u0003L1!a0A\u0005\u0019y\u0005\u000f^5p]B)q(a1/]%\u0019\u0011Q\u0019!\u0003\rQ+\b\u000f\\33\u0011!\tImGA\u0001\u0002\u00049\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u001a\t\u0005\u00037\t\t.\u0003\u0003\u0002T\u0006u!AB(cU\u0016\u001cG\u000f")
public class ST_SetSrid
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
BinaryLike<Expression>,
Serializable {
    private Expression replacement;
    private final Expression geo;
    private final Expression srid;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ST_SetSrid x$0) {
        return ST_SetSrid$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ST_SetSrid> tupled() {
        return ST_SetSrid$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ST_SetSrid>> curried() {
        return ST_SetSrid$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ST_SetSrid sT_SetSrid = this;
        synchronized (sT_SetSrid) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ST_SetSrid sT_SetSrid = this;
        synchronized (sT_SetSrid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression geo() {
        return this.geo;
    }

    public Expression srid() {
        return this.srid;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{GeographyType$.MODULE$, GeometryType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    private Expression replacement$lzycompute() {
        ST_SetSrid sT_SetSrid = this;
        synchronized (sT_SetSrid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Class<STUtils> x$1 = STUtils.class;
                DataType x$2 = STExpressionUtils$.MODULE$.geospatialTypeWithSrid(this.geo().dataType(), this.srid());
                String x$3 = "stSetSrid";
                .colon.colon x$4 = new .colon.colon((Object)this.geo(), (List)new .colon.colon((Object)this.srid(), (List)Nil$.MODULE$));
                boolean x$5 = false;
                Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
                Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
                this.replacement = new StaticInvoke(STUtils.class, x$2, "stSetSrid", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "st_setsrid";
    }

    @Override
    public Expression left() {
        return this.geo();
    }

    @Override
    public Expression right() {
        return this.srid();
    }

    @Override
    public ST_SetSrid withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ST_SetSrid copy(Expression geo, Expression srid) {
        return new ST_SetSrid(geo, srid);
    }

    public Expression copy$default$1() {
        return this.geo();
    }

    public Expression copy$default$2() {
        return this.srid();
    }

    @Override
    public String productPrefix() {
        return "ST_SetSrid";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.geo();
            }
            case 1: {
                return this.srid();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ST_SetSrid;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "geo";
            }
            case 1: {
                return "srid";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ST_SetSrid)) return false;
        boolean bl = true;
        if (!bl) return false;
        ST_SetSrid sT_SetSrid = (ST_SetSrid)x$1;
        Expression expression = this.geo();
        Expression expression2 = sT_SetSrid.geo();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.srid();
        Expression expression4 = sT_SetSrid.srid();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sT_SetSrid.canEqual(this)) return false;
        return true;
    }

    public ST_SetSrid(Expression geo, Expression srid) {
        this.geo = geo;
        this.srid = srid;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        Statics.releaseFence();
    }
}

