/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.io.Serializable;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.Deploy$;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterPersistenceEngine;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=a!\u0002\u0007\u000e\u0001MI\u0002\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011]\u0002!\u0011!Q\u0001\naB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019!\u0006\u0001)A\u0005\u001b\")Q\u000b\u0001C\u0001-\")\u0011\f\u0001C!5\")q\f\u0001C!A\")q\r\u0001C!Q\")\u0011\u0010\u0001C!u\n1#l\\8lK\u0016\u0004XM]'fg>\u001c8\t\\;ti\u0016\u0014\b+\u001a:tSN$XM\\2f\u000b:<\u0017N\\3\u000b\u00059y\u0011!B7fg>\u001c(B\u0001\t\u0012\u0003\u001d\u0019G.^:uKJT!AE\n\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0014\t\u0001Q\u0002\u0005\n\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0012S\"A\u0007\n\u0005\rj!!H'fg>\u001c8\t\\;ti\u0016\u0014\b+\u001a:tSN$XM\\2f\u000b:<\u0017N\\3\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d\u001a\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005%2#a\u0002'pO\u001eLgnZ\u0001\bE\u0006\u001cX\rR5s\u0007\u0001\u0001\"!\f\u001b\u000f\u00059\u0012\u0004CA\u0018\u001d\u001b\u0005\u0001$BA\u0019,\u0003\u0019a$o\\8u}%\u00111\u0007H\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u000249\u0005\u0011!p\u001b\t\u0003syj\u0011A\u000f\u0006\u0003wq\n\u0011B\u001a:b[\u0016<xN]6\u000b\u0005u*\u0012aB2ve\u0006$xN]\u0005\u0003\u007fi\u0012\u0001cQ;sCR|'O\u0012:b[\u0016<xN]6\u0002\t\r|gN\u001a\t\u0003\u0005\u000ek\u0011aE\u0005\u0003\tN\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\rqJg.\u001b;?)\u00119\u0005*\u0013&\u0011\u0005\u0005\u0002\u0001\"\u0002\u0016\u0005\u0001\u0004a\u0003\"B\u001c\u0005\u0001\u0004A\u0004\"\u0002!\u0005\u0001\u0004\t\u0015AC<pe.Lgn\u001a#jeV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!A.\u00198h\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!!N(\u0002\u0017]|'o[5oO\u0012K'\u000fI\u0001\u0005a\u0006$\b\u000e\u0006\u0002-/\")\u0001l\u0002a\u0001Y\u0005!a.Y7f\u0003\u001d)\u0007\u0010];oO\u0016$\"a\u00170\u0011\u0005ma\u0016BA/\u001d\u0005\u0011)f.\u001b;\t\u000baC\u0001\u0019\u0001\u0017\u0002\u000fA,'o]5tiR\u00191,\u00192\t\u000baK\u0001\u0019\u0001\u0017\t\u000b\rL\u0001\u0019\u00013\u0002\u0007=\u0014'\u000e\u0005\u0002OK&\u0011am\u0014\u0002\u0007\u001f\nTWm\u0019;\u0002\u000b\u0019,Go\u00195\u0016\u0005%|GC\u00016y!\rY2.\\\u0005\u0003Yr\u0011aa\u00149uS>t\u0007C\u00018p\u0019\u0001!Q\u0001\u001d\u0006C\u0002E\u0014\u0011\u0001V\t\u0003eV\u0004\"aG:\n\u0005Qd\"a\u0002(pi\"Lgn\u001a\t\u00037YL!a\u001e\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003Y\u0015\u0001\u0007A&\u0001\u0005gKR\u001c\u0007.\u00117m+\rY\u0018Q\u0002\u000b\u0002yB)Q0!\u0002\u0002\f9\u0019a0!\u0001\u000f\u0005=z\u0018\"A\u000f\n\u0007\u0005\rA$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0011\u0011\u0002\u0002\t\u0013R,'/\u00192mK*\u0019\u00111\u0001\u000f\u0011\u00079\fi\u0001B\u0003q\u0017\t\u0007\u0011\u000f")
public class ZookeeperMesosClusterPersistenceEngine
implements MesosClusterPersistenceEngine,
Logging {
    private final CuratorFramework zk;
    private final String workingDir;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String workingDir() {
        return this.workingDir;
    }

    public String path(String name) {
        return new StringBuilder(1).append(this.workingDir()).append("/").append(name).toString();
    }

    @Override
    public void expunge(String name) {
        this.zk.delete().forPath(this.path(name));
    }

    @Override
    public void persist(String name, Object obj) {
        byte[] serialized = Utils$.MODULE$.serialize(obj);
        String zkPath = this.path(name);
        ((PathAndBytesable)this.zk.create().withMode(CreateMode.PERSISTENT)).forPath(zkPath, serialized);
    }

    @Override
    public <T> Option<T> fetch(String name) {
        None$ none$;
        String zkPath = this.path(name);
        try {
            byte[] fileData = (byte[])this.zk.getData().forPath(zkPath);
            none$ = new Some(Utils$.MODULE$.deserialize(fileData));
        }
        catch (KeeperException.NoNodeException e) {
            none$ = None$.MODULE$;
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Exception while reading persisted file, deleting", e);
            this.zk.delete().forPath(zkPath);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public <T> Iterable<T> fetchAll() {
        return (Iterable)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.zk.getChildren().forPath(this.workingDir())).asScala()).flatMap((Function1 & Serializable)name -> this.fetch((String)name));
    }

    public ZookeeperMesosClusterPersistenceEngine(String baseDir, CuratorFramework zk, SparkConf conf) {
        this.zk = zk;
        Logging.$init$((Logging)this);
        this.workingDir = new StringBuilder(1).append((String)((Option)conf.get((ConfigEntry)Deploy$.MODULE$.ZOOKEEPER_DIRECTORY())).getOrElse((Function0 & Serializable)() -> "/spark_mesos_dispatcher")).append("/").append(baseDir).toString();
        SparkCuratorUtil$.MODULE$.mkdir(zk, this.workingDir());
    }
}

