/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IServiceLabelDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class ServiceLabelEsDAO
extends EsDAO
implements IServiceLabelDAO {
    private int maxSize;

    public ServiceLabelEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.maxSize = config.getMetadataQueryMaxSize();
    }

    public List<String> queryAllLabels(String serviceId) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("service_label");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("service_label")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"service_label"));
        }
        query.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.maxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return response.getHits().getHits().stream().map(this::parseLabel).collect(Collectors.toList());
    }

    private String parseLabel(SearchHit hit) {
        return (String)hit.getSource().get("label");
    }
}

