/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.ebpf.provider.handler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import io.grpc.stub.StreamObserver;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.ContinuousProfilingCause;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.ContinuousProfilingPolicyQuery;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.ContinuousProfilingReport;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.ContinuousProfilingServiceGrpc;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.ContinuousProfilingServicePolicyQuery;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.ContinuousProfilingTriggeredMonitorType;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamProcessor;
import org.apache.skywalking.oap.server.core.command.CommandService;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingMonitorType;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.input.EBPFNetworkDataCollectingSettings;
import org.apache.skywalking.oap.server.core.query.input.EBPFNetworkSamplingRule;
import org.apache.skywalking.oap.server.core.query.type.ContinuousProfilingSingleValueCause;
import org.apache.skywalking.oap.server.core.query.type.ContinuousProfilingTriggeredCause;
import org.apache.skywalking.oap.server.core.query.type.ContinuousProfilingURICause;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskContinuousProfiling;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskExtension;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.network.trace.component.command.ContinuousProfilingPolicyCommand;
import org.apache.skywalking.oap.server.receiver.ebpf.provider.EBPFReceiverModuleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousProfilingServiceHandler
extends ContinuousProfilingServiceGrpc.ContinuousProfilingServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContinuousProfilingServiceHandler.class);
    private static final Gson GSON = new Gson();
    private IContinuousProfilingPolicyDAO policyDAO;
    private final CommandService commandService;
    private final Cache<String, PolicyWrapper> policyCache;

    public ContinuousProfilingServiceHandler(ModuleManager moduleManager, EBPFReceiverModuleConfig config) {
        this.policyDAO = (IContinuousProfilingPolicyDAO)moduleManager.find("storage").provider().getService(IContinuousProfilingPolicyDAO.class);
        this.commandService = (CommandService)moduleManager.find("core").provider().getService(CommandService.class);
        this.policyCache = CacheBuilder.newBuilder().expireAfterWrite((long)config.getContinuousPolicyCacheTimeout(), TimeUnit.SECONDS).build();
    }

    public void queryPolicies(ContinuousProfilingPolicyQuery request, StreamObserver<Commands> responseObserver) {
        Map<String, String> policiesQuery = request.getPoliciesList().stream().collect(Collectors.toMap(s -> IDManager.ServiceID.buildId((String)s.getServiceName(), (boolean)true), ContinuousProfilingServicePolicyQuery::getUuid, (s1, s2) -> s1));
        if (CollectionUtils.isEmpty(policiesQuery)) {
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
            return;
        }
        try {
            ArrayList<String> serviceIdList = new ArrayList<String>(policiesQuery.keySet());
            HashMap<Object, ContinuousProfilingPolicy> policiesInDB = new HashMap<Object, ContinuousProfilingPolicy>();
            ListIterator serviceIdIt = serviceIdList.listIterator();
            while (serviceIdIt.hasNext()) {
                String serviceId = (String)serviceIdIt.next();
                PolicyWrapper policyWrapper = (PolicyWrapper)this.policyCache.getIfPresent((Object)serviceId);
                if (policyWrapper == null) continue;
                serviceIdIt.remove();
                if (policyWrapper.policy == null) continue;
                policiesInDB.put(serviceId, policyWrapper.policy);
            }
            if (serviceIdList.isEmpty()) {
                this.sendEmptyCommands(responseObserver);
                return;
            }
            List queriedFromDB = this.policyDAO.queryPolicies(serviceIdList);
            for (ContinuousProfilingPolicy continuousProfilingPolicy : queriedFromDB) {
                policiesInDB.put(continuousProfilingPolicy.getServiceId(), continuousProfilingPolicy);
                this.policyCache.put((Object)continuousProfilingPolicy.getServiceId(), (Object)new PolicyWrapper(continuousProfilingPolicy));
                serviceIdList.remove(continuousProfilingPolicy.getServiceId());
            }
            for (String string : serviceIdList) {
                this.policyCache.put((Object)string, (Object)new PolicyWrapper(null));
            }
            ArrayList<ContinuousProfilingPolicy> updatePolicies = new ArrayList<ContinuousProfilingPolicy>();
            for (Map.Entry<String, String> entry : policiesQuery.entrySet()) {
                String serviceId = entry.getKey();
                ContinuousProfilingPolicy policyInDB = (ContinuousProfilingPolicy)policiesInDB.get(serviceId);
                if (policyInDB == null && StringUtil.isNotEmpty((String)entry.getValue())) {
                    ContinuousProfilingPolicy emptyPolicy = new ContinuousProfilingPolicy();
                    emptyPolicy.setServiceId(entry.getKey());
                    emptyPolicy.setUuid("");
                    updatePolicies.add(emptyPolicy);
                    continue;
                }
                if (policyInDB == null || Objects.equals(policyInDB.getUuid(), entry.getValue())) continue;
                updatePolicies.add(policyInDB);
            }
            if (CollectionUtils.isEmpty(updatePolicies)) {
                this.sendEmptyCommands(responseObserver);
                return;
            }
            ContinuousProfilingPolicyCommand continuousProfilingPolicyCommand = this.commandService.newContinuousProfilingServicePolicyCommand(updatePolicies);
            Commands.Builder builder = Commands.newBuilder();
            builder.addCommands(continuousProfilingPolicyCommand.serialize());
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
            return;
        }
        catch (Exception e) {
            log.warn("query continuous profiling service policies failure", (Throwable)e);
            this.sendEmptyCommands(responseObserver);
            return;
        }
    }

    private void sendEmptyCommands(StreamObserver<Commands> responseObserver) {
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void reportProfilingTask(ContinuousProfilingReport request, StreamObserver<Commands> responseObserver) {
        long currentTime = System.currentTimeMillis();
        EBPFProfilingTaskRecord task = new EBPFProfilingTaskRecord();
        String serviceId = IDManager.ServiceID.buildId((String)request.getServiceName(), (boolean)true);
        String instanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)request.getInstanceName());
        String processId = IDManager.ProcessID.buildId((String)instanceId, (String)request.getProcessName());
        task.setServiceId(serviceId);
        task.setProcessLabelsJson("");
        task.setInstanceId(instanceId);
        task.setStartTime(currentTime);
        task.setTriggerType(EBPFProfilingTriggerType.CONTINUOUS_PROFILING.value());
        task.setFixedTriggerDuration((long)request.getDuration());
        task.setCreateTime(currentTime);
        task.setLastUpdateTime(currentTime);
        task.setTimeBucket(TimeBucket.getRecordTimeBucket((long)currentTime));
        EBPFProfilingTaskContinuousProfiling continuousProfiling = new EBPFProfilingTaskContinuousProfiling();
        continuousProfiling.setProcessId(processId);
        continuousProfiling.setProcessName(request.getProcessName());
        continuousProfiling.setCauses(request.getCausesList().stream().map(this::parseTaskCause).collect(Collectors.toList()));
        this.settingTargetTask(request, task, continuousProfiling);
        task.setContinuousProfilingJson(GSON.toJson((Object)continuousProfiling));
        task.generateLogicalId();
        NoneStreamProcessor.getInstance().in((NoneStream)task);
        Commands.Builder builder = Commands.newBuilder();
        builder.addCommands(this.commandService.newContinuousProfilingReportCommand(task.getLogicalId()).serialize());
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    private void settingTargetTask(ContinuousProfilingReport request, EBPFProfilingTaskRecord task, EBPFProfilingTaskContinuousProfiling continuousProfiling) {
        switch (request.getTargetTaskCase()) {
            case ONCPU: {
                task.setTargetType(EBPFProfilingTargetType.ON_CPU.value());
                break;
            }
            case OFFCPU: {
                task.setTargetType(EBPFProfilingTargetType.OFF_CPU.value());
                break;
            }
            case NETWORK: {
                task.setTargetType(EBPFProfilingTargetType.NETWORK.value());
                EBPFProfilingTaskExtension networkExtension = new EBPFProfilingTaskExtension();
                networkExtension.setNetworkSamplings(request.getNetwork().getSamplingURIRegexesList().stream().map(uri -> {
                    EBPFNetworkSamplingRule rule = new EBPFNetworkSamplingRule();
                    rule.setMinDuration(Integer.valueOf(0));
                    rule.setWhen4xx(true);
                    rule.setWhen5xx(true);
                    EBPFNetworkDataCollectingSettings setting = new EBPFNetworkDataCollectingSettings();
                    setting.setRequireCompleteRequest(true);
                    setting.setRequireCompleteResponse(true);
                    rule.setSettings(setting);
                    return rule;
                }).collect(Collectors.toList()));
                task.setExtensionConfigJson(GSON.toJson((Object)networkExtension));
                break;
            }
            default: {
                throw new IllegalArgumentException("the continuous profiling task type cannot recognized");
            }
        }
    }

    private ContinuousProfilingTriggeredCause parseTaskCause(ContinuousProfilingCause cause) {
        ContinuousProfilingTriggeredCause result = new ContinuousProfilingTriggeredCause();
        ContinuousProfilingMonitorType type = ContinuousProfilingMonitorType.valueOf((ContinuousProfilingTriggeredMonitorType)cause.getType());
        result.setType(type);
        Object caseFormat = "";
        switch (cause.getCauseCase()) {
            case SINGLEVALUE: {
                ContinuousProfilingSingleValueCause singleValue = new ContinuousProfilingSingleValueCause();
                singleValue.setThreshold(this.thresholdToLong(cause.getSingleValue().getThreshold()));
                singleValue.setCurrent(this.thresholdToLong(cause.getSingleValue().getCurrent()));
                result.setSingleValue(singleValue);
                caseFormat = this.generateCauseString(type, cause.getSingleValue().getThreshold(), cause.getSingleValue().getCurrent());
                break;
            }
            case URI: {
                String urlCause;
                ContinuousProfilingURICause uriCause = new ContinuousProfilingURICause();
                switch (cause.getUri().getUriCase()) {
                    case PATH: {
                        urlCause = cause.getUri().getPath();
                        uriCause.setUriPath(cause.getUri().getPath());
                        break;
                    }
                    case REGEX: {
                        urlCause = cause.getUri().getRegex();
                        uriCause.setUriRegex(cause.getUri().getRegex());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("the uri case not set");
                    }
                }
                uriCause.setThreshold(this.thresholdToLong(cause.getUri().getThreshold()));
                uriCause.setCurrent(this.thresholdToLong(cause.getUri().getCurrent()));
                result.setUri(uriCause);
                caseFormat = this.generateCauseString(type, cause.getUri().getThreshold(), cause.getUri().getCurrent());
                if (!StringUtils.isNotEmpty((CharSequence)urlCause)) break;
                caseFormat = (String)caseFormat + " on " + urlCause;
            }
        }
        result.setMessage(result.getType().name() + ": " + (String)caseFormat);
        return result;
    }

    private String generateCauseString(ContinuousProfilingMonitorType type, double threshold, double current) {
        NumberFormat percentInstance = NumberFormat.getPercentInstance();
        percentInstance.setMinimumFractionDigits(2);
        switch (type) {
            case HTTP_ERROR_RATE: 
            case PROCESS_CPU: {
                return String.format("current %s >= threshold %s", percentInstance.format(current / 100.0), percentInstance.format(threshold / 100.0));
            }
            case PROCESS_THREAD_COUNT: 
            case SYSTEM_LOAD: {
                return String.format("current %d >= threshold %d", (int)current, (int)threshold);
            }
            case HTTP_AVG_RESPONSE_TIME: {
                return String.format("current %.2fms >= threshold %.2fms", current, threshold);
            }
        }
        return "";
    }

    private long thresholdToLong(double val) {
        return (long)(val * 100.0);
    }

    private static class PolicyWrapper {
        final ContinuousProfilingPolicy policy;

        @Generated
        public PolicyWrapper(ContinuousProfilingPolicy policy) {
            this.policy = policy;
        }
    }
}

