/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.trace.v1.BanyandbTrace;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;

public class TraceQuery
extends AbstractQuery<BanyandbTrace.QueryRequest> {
    private int offset = 0;
    private int limit = 20;
    private AbstractQuery.OrderBy orderBy;
    private Set<String> stages;

    public TraceQuery(List<String> groups, String name, TimestampRange timestampRange, Set<String> projections) {
        super(groups, name, timestampRange, projections);
    }

    public TraceQuery(List<String> groups, String name, Set<String> projections) {
        this(groups, name, null, projections);
    }

    public TraceQuery and(PairQueryCondition<?> condition) {
        return (TraceQuery)super.and(condition);
    }

    public TraceQuery or(PairQueryCondition<?> condition) {
        return (TraceQuery)super.or(condition);
    }

    public TraceQuery stages(Set<String> stages) {
        this.stages = stages;
        return this;
    }

    @Override
    BanyandbTrace.QueryRequest build(MetadataCache.EntityMetadata entityMetadata) throws BanyanDBException {
        if (entityMetadata == null) {
            throw new IllegalArgumentException("entity metadata is null");
        }
        BanyandbTrace.QueryRequest.Builder builder = BanyandbTrace.QueryRequest.newBuilder();
        builder.setName(this.name);
        builder.addAllGroups(this.groups);
        if (this.timestampRange != null) {
            builder.setTimeRange(this.timestampRange.build());
        }
        builder.addAllTagProjection(this.tagProjections);
        this.buildCriteria().ifPresent(builder::setCriteria);
        builder.setOffset(this.offset);
        builder.setLimit(this.limit);
        if (this.orderBy != null) {
            builder.setOrderBy(this.orderBy.build());
        }
        if (this.stages != null && !this.stages.isEmpty()) {
            builder.addAllStages(this.stages);
        }
        builder.setTrace(this.trace);
        return builder.build();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOrderBy(AbstractQuery.OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public void setStages(Set<String> stages) {
        this.stages = stages;
    }
}

