/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.encoding;

import com.linecorp.armeria.client.encoding.StreamDecoder;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.encoding.AbstractHttpDecodedResponse;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class StaticHttpDecodedResponse
extends AbstractHttpDecodedResponse {
    private final StreamDecoder decoder;
    @Nullable
    private final MediaType contentType;

    public StaticHttpDecodedResponse(HttpResponse delegate, StreamDecoder decoder, @Nullable MediaType contentType) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.decoder = Objects.requireNonNull(decoder, "decoder");
        this.contentType = contentType;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        ResponseHeaders responseHeaders;
        if (obj instanceof HttpData) {
            return this.decoder.decode((HttpData)obj);
        }
        if (obj instanceof ResponseHeaders && !(responseHeaders = (ResponseHeaders)obj).status().isInformational()) {
            ResponseHeadersBuilder builder = responseHeaders.toBuilder();
            builder.remove(HttpHeaderNames.CONTENT_LENGTH);
            if (this.contentType == null) {
                builder.remove(HttpHeaderNames.CONTENT_TYPE);
            } else {
                builder.contentType(this.contentType);
            }
            return builder.build();
        }
        return obj;
    }

    @Override
    @Nonnull
    StreamDecoder decoder() {
        return this.decoder;
    }
}

