/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mock;

import java.util.HashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.RouterGroupingState;

public class MockInvokersSelector<T>
extends AbstractStateRouter<T> {
    public static final String NAME = "MOCK_ROUTER";
    private volatile BitList<Invoker<T>> normalInvokers = BitList.emptyList();
    private volatile BitList<Invoker<T>> mockedInvokers = BitList.emptyList();

    public MockInvokersSelector(URL url) {
        super(url);
    }

    @Override
    protected BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder, Holder<String> messageHolder) throws RpcException {
        if (CollectionUtils.isEmpty(invokers)) {
            if (needToPrintMessage) {
                messageHolder.set("Empty invokers. Directly return.");
            }
            return invokers;
        }
        if (invocation.getObjectAttachments() == null) {
            if (needToPrintMessage) {
                messageHolder.set("ObjectAttachments from invocation are null. Return normal Invokers.");
            }
            return invokers.and(this.normalInvokers);
        }
        String value = (String)invocation.getObjectAttachmentWithoutConvert("invocation.need.mock");
        if (value == null) {
            if (needToPrintMessage) {
                messageHolder.set("invocation.need.mock not set. Return normal Invokers.");
            }
            return invokers.and(this.normalInvokers);
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            if (needToPrintMessage) {
                messageHolder.set("invocation.need.mock is true. Return mocked Invokers.");
            }
            return invokers.and(this.mockedInvokers);
        }
        if (needToPrintMessage) {
            messageHolder.set("Directly Return. Reason: invocation.need.mock is set but not match true");
        }
        return invokers;
    }

    @Override
    public void notify(BitList<Invoker<T>> invokers) {
        this.cacheMockedInvokers(invokers);
        this.cacheNormalInvokers(invokers);
    }

    private void cacheMockedInvokers(BitList<Invoker<T>> invokers) {
        Object clonedInvokers = invokers.clone();
        clonedInvokers.removeIf(invoker -> !invoker.getUrl().getProtocol().equals("mock"));
        this.mockedInvokers = clonedInvokers;
    }

    private void cacheNormalInvokers(BitList<Invoker<T>> invokers) {
        Object clonedInvokers = invokers.clone();
        clonedInvokers.removeIf(invoker -> invoker.getUrl().getProtocol().equals("mock"));
        this.normalInvokers = clonedInvokers;
    }

    @Override
    protected String doBuildSnapshot() {
        HashMap grouping = new HashMap();
        grouping.put("Mocked", this.mockedInvokers);
        grouping.put("Normal", this.normalInvokers);
        return new RouterGroupingState(this.getClass().getSimpleName(), this.mockedInvokers.size() + this.normalInvokers.size(), grouping).toString();
    }
}

