/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.context.event;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DeferredApplicationEventPublisher
implements ApplicationEventPublisher,
ApplicationListener<ContextRefreshedEvent> {
    private static final String EARLY_APPLICATION_EVENTS_FIELD_NAME = "earlyApplicationEvents";
    private static final String APPLICATION_EVENT_MULTICASTER_FIELD_NAME = "applicationEventMulticaster";
    private static final String PUBLISH_EVENT_OBJECT_METHOD_NAME = "publishEvent";
    private static final Method PUBLISH_EVENT_METHOD = DeferredApplicationEventPublisher.detectPublishEventMethod();
    private final ApplicationEventPublisher delegate;
    private final ConfigurableApplicationContext context;
    private final ConcurrentLinkedQueue<ApplicationEvent> deferredEvents = new ConcurrentLinkedQueue();
    private final boolean shouldDefer;

    public DeferredApplicationEventPublisher(ApplicationEventPublisher delegate) {
        Assert.notNull((Object)delegate, (String)"The ApplicationEventPublisher argument must not be null");
        this.delegate = delegate;
        ConfigurableApplicationContext configurableApplicationContext = this.context = delegate instanceof ConfigurableApplicationContext ? (ConfigurableApplicationContext)delegate : null;
        if (this.context != null) {
            this.context.addApplicationListener((ApplicationListener)this);
        }
        this.shouldDefer = !this.supportsEarlyApplicationEvents() || !this.isInitializedApplicationEventMulticaster();
    }

    protected boolean supportsPublishEventMethod() {
        return PUBLISH_EVENT_METHOD != null;
    }

    public void publishEvent(ApplicationEvent event) {
        if (this.shouldDefer) {
            this.deferEvent(event);
        } else {
            this.doPublishEvent(event);
        }
    }

    private void doPublishEvent(ApplicationEvent event) {
        this.delegate.publishEvent(event);
    }

    private void deferEvent(ApplicationEvent event) {
        try {
            this.deferredEvents.add(event);
        }
        catch (Exception ignore) {
            this.deferredEvents.add(event);
        }
    }

    public void publishEvent(Object event) {
        if (this.supportsEarlyApplicationEvents() && this.supportsPublishEventMethod()) {
            ReflectionUtils.invokeMethod((Method)PUBLISH_EVENT_METHOD, (Object)this.delegate, (Object[])new Object[]{event});
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.supportsEarlyApplicationEvents()) {
            return;
        }
        ApplicationContext currentContext = event.getApplicationContext();
        if (!currentContext.equals(this.delegate)) {
            return;
        }
        this.replayDeferredEvents();
    }

    private void replayDeferredEvents() {
        Iterator<ApplicationEvent> iterator = this.deferredEvents.iterator();
        while (iterator.hasNext()) {
            ApplicationEvent event = iterator.next();
            this.doPublishEvent(event);
            iterator.remove();
        }
    }

    private boolean supportsEarlyApplicationEvents() {
        return this.context != null && ReflectionUtils.findField(this.context.getClass(), (String)EARLY_APPLICATION_EVENTS_FIELD_NAME) != null;
    }

    private boolean isInitializedApplicationEventMulticaster() {
        return this.context != null && ReflectionUtils.findField(this.context.getClass(), (String)APPLICATION_EVENT_MULTICASTER_FIELD_NAME) != null;
    }

    private static Method detectPublishEventMethod() {
        return ReflectionUtils.findMethod(ApplicationEventPublisher.class, (String)PUBLISH_EVENT_OBJECT_METHOD_NAME, (Class[])new Class[]{Object.class});
    }
}

