/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedInit;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.nacos.NacosDataChangedInit;
import org.apache.shenyu.admin.listener.nacos.NacosDataChangedListener;
import org.apache.shenyu.infra.nacos.autoconfig.ConditionOnSyncNacos;
import org.apache.shenyu.infra.nacos.autoconfig.NacosProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionOnSyncNacos
@EnableConfigurationProperties(value={NacosProperties.class})
public class NacosSyncConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ConfigService.class})
    public ConfigService nacosConfigService(NacosProperties nacosProp) throws Exception {
        Properties properties = new Properties();
        if (Objects.nonNull(nacosProp.getNacos().getAcm()) && nacosProp.getNacos().getAcm().isEnabled()) {
            properties.put("endpoint", nacosProp.getNacos().getAcm().getEndpoint());
            properties.put("namespace", nacosProp.getNacos().getAcm().getNamespace());
            properties.put("accessKey", nacosProp.getNacos().getAcm().getAccessKey());
            properties.put("secretKey", nacosProp.getNacos().getAcm().getSecretKey());
        } else {
            properties.put("serverAddr", nacosProp.getNacos().getUrl());
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getNacos().getNamespace())) {
                properties.put("namespace", nacosProp.getNacos().getNamespace());
            }
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getNacos().getUsername())) {
                properties.put("username", nacosProp.getNacos().getUsername());
            }
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getNacos().getPassword())) {
                properties.put("password", nacosProp.getNacos().getPassword());
            }
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getNacos().getContextPath())) {
                properties.put("contextPath", nacosProp.getNacos().getContextPath());
            }
        }
        return NacosFactory.createConfigService((Properties)properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={NacosDataChangedListener.class})
    public DataChangedListener nacosDataChangedListener(ConfigService configService) {
        return new NacosDataChangedListener(configService);
    }

    @Bean
    @ConditionalOnMissingBean(value={NacosDataChangedInit.class})
    public DataChangedInit nacosDataChangedInit(ConfigService configService) {
        return new NacosDataChangedInit(configService);
    }
}

