/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.locks;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import org.springframework.integration.util.CheckedCallable;
import org.springframework.integration.util.CheckedRunnable;

@FunctionalInterface
public interface LockRegistry {
    public Lock obtain(Object var1);

    default public <E extends Throwable> void executeLocked(Object lockKey, CheckedRunnable<E> runnable) throws E, InterruptedException {
        this.executeLocked(lockKey, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, E extends Throwable> T executeLocked(Object lockKey, CheckedCallable<T, E> callable) throws E, InterruptedException {
        Lock lock = this.obtain(lockKey);
        lock.lockInterruptibly();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    default public <E extends Throwable> void executeLocked(Object lockKey, Duration waitLockDuration, CheckedRunnable<E> runnable) throws E, InterruptedException, TimeoutException {
        this.executeLocked(lockKey, waitLockDuration, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, E extends Throwable> T executeLocked(Object lockKey, Duration waitLockDuration, CheckedCallable<T, E> callable) throws E, InterruptedException, TimeoutException {
        Lock lock = this.obtain(lockKey);
        if (!lock.tryLock(waitLockDuration.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("The lock [%s] was not acquired in time: %s".formatted(lockKey, waitLockDuration));
        }
        try {
            T t = callable.call();
            return t;
        }
        finally {
            lock.unlock();
        }
    }
}

