/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.sharding.strategy.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.strategy.JobShardingStrategy;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.strategy.type.AverageAllocationJobShardingStrategy;

public class SingleShardingBalanceJobShardingStrategy
implements JobShardingStrategy {
    private final AverageAllocationJobShardingStrategy averageAllocationJobShardingStrategy = new AverageAllocationJobShardingStrategy();

    @Override
    public Map<JobInstance, List<Integer>> sharding(List<JobInstance> jobInstances, String jobName, int shardingTotalCount) {
        int shardingUnitsSize = jobInstances.size();
        int offset = Math.abs(jobName.hashCode() + Long.valueOf(System.currentTimeMillis()).intValue()) % shardingUnitsSize;
        ArrayList<JobInstance> result = new ArrayList<JobInstance>(shardingUnitsSize);
        for (int i = 0; i < shardingUnitsSize; ++i) {
            int index = (i + offset) % shardingUnitsSize;
            result.add(jobInstances.get(index));
        }
        return this.averageAllocationJobShardingStrategy.sharding(result, jobName, shardingTotalCount);
    }

    public String getType() {
        return "SINGLE_SHARDING_BALANCE";
    }
}

