/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.builder;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.SystemTable;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.SystemSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.yaml.snakeyaml.Yaml;

public final class SystemSchemaBuilder {
    private static final YamlTableSwapper TABLE_SWAPPER = new YamlTableSwapper();

    public static Map<String, ShardingSphereSchema> build(String databaseName, DatabaseType databaseType, ConfigurationProperties props) {
        SystemDatabase systemDatabase = new SystemDatabase(databaseType);
        boolean isSystemSchemaMetaDataEnabled = SystemSchemaBuilder.isSystemSchemaMetaDataEnabled(props.getProps());
        return SystemSchemaBuilder.getSystemSchemas(databaseName, databaseType, systemDatabase).stream().collect(Collectors.toMap(String::toLowerCase, each -> SystemSchemaBuilder.createSchema(each, databaseType, isSystemSchemaMetaDataEnabled), (oldValue, currentValue) -> currentValue, LinkedHashMap::new));
    }

    private static boolean isSystemSchemaMetaDataEnabled(Properties props) {
        TemporaryConfigurationPropertyKey configKey = TemporaryConfigurationPropertyKey.SYSTEM_SCHEMA_METADATA_ASSEMBLY_ENABLED;
        return Boolean.parseBoolean(props.getOrDefault((Object)configKey.getKey(), configKey.getDefaultValue()).toString());
    }

    private static Collection<String> getSystemSchemas(String originalDatabaseName, DatabaseType databaseType, SystemDatabase systemDatabase) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return systemDatabase.getSystemSchemas(dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() ? "postgres" : originalDatabaseName);
    }

    private static ShardingSphereSchema createSchema(String schemaName, DatabaseType databaseType, boolean isSystemSchemaMetadataEnabled) {
        LinkedList<ShardingSphereTable> tables = new LinkedList<ShardingSphereTable>();
        SystemTable systemTable = new SystemTable(databaseType);
        for (InputStream each : SystemSchemaManager.getAllInputStreams(databaseType.getType(), schemaName)) {
            YamlShardingSphereTable metaData = (YamlShardingSphereTable)new Yaml().loadAs(each, YamlShardingSphereTable.class);
            if (!isSystemSchemaMetadataEnabled && !systemTable.isSupportedSystemTable(schemaName, metaData.getName())) continue;
            tables.add(TABLE_SWAPPER.swapToObject(metaData));
        }
        return new ShardingSphereSchema(schemaName, databaseType, tables, Collections.emptyList());
    }

    @Generated
    private SystemSchemaBuilder() {
    }
}

